import ast
import maya.cmds as cmds
import maya.mel as mel

import maya.OpenMaya as OpenMaya

import maya_assemblies.lib.representations.representation as representation


def create_aov(root_node):
    light_group_list = []
    for element in cmds.listRelatives(root_node, ad=True):
        if not cmds.attributeQuery('aovLightGroup', n=element, exists=True):
            continue
        light_group = cmds.getAttr('%s.aovLightGroup' % element)
        if light_group and light_group not in light_group_list:
            light_group_list.append(light_group)

    if len(light_group_list) == 0:
        return True

    light_group_list = light_group_list[:-1]

    for light_group in light_group_list:
        aov_name = 'rsAov_%s'%light_group
        if not cmds.objExists(aov_name):
            rsAov = mel.eval('redshiftCreateAov("Beauty");')
        else:
            rsAov = aov_name
        cmds.setAttr('%s.name' % rsAov, 'Beauty_%s' % light_group, type='string')
        cmds.setAttr('%s.lightGroupList' % rsAov, light_group, type='string')
        cmds.setAttr('%s.fileFormat' % rsAov, 2)

        cmds.rename(rsAov, aov_name)

    mel.eval('redshiftUpdateActiveAovList();')
    return True

class LightRigRepresentation(representation.Representation):
    typename = "scene"

    def activate(self):
        assembly = self.assembly.thisMObject()
        fnassembly = OpenMaya.MFnAssembly(assembly)

        ignore_version = cmds.optionVar(query='fileIgnoreVersion') == 1

        fnassembly.importFile(self.path, None, True, None, ignore_version)

        namespace = self.get_assembly_namespace()
        loaded_nodes = cmds.namespaceInfo(namespace, ls=True, dagPath=True )
        root = self.get_assembly_name()
        for node in loaded_nodes:
            bits = node.split('|')
            if len(bits) == 2:
                cmds.parent(node, root)

        create_aov(root)



        return True

    def can_apply_edits(self):
        return True


    def post_activate(self):


        assembly_type_plug = OpenMaya.MPlug(self.assembly.thisMObject(), self.assembly.assembly_type)
        ass_type = assembly_type_plug.asString()
        if str(ass_type) != 'Shader':
            return

        namespace_plug = OpenMaya.MPlug(self.assembly.thisMObject(), self.assembly.arep_namespace)
        namespace = namespace_plug.asString()
        assemby_name = self.assembly.get_assembly_name()

        all_data = {}
        search = '%s_NS:*' % assemby_name
        all_sg = cmds.ls(search, type='shadingEngine')
        for sg_node in all_sg:
            if not cmds.attributeQuery('shading_io_info', node=sg_node, exists=True):
                continue
            value_raw = cmds.getAttr('%s.shading_io_info' % sg_node)
            try:
                value = ast.literal_eval(value_raw)
            except:
                value = {}

            all_data[sg_node] = value
        data_str = str(all_data)
        shading_plug = OpenMaya.MPlug(self.assembly.thisMObject(), self.assembly.shader_assigment)
        shading_plug.setLocked(False)

        cmds.setAttr('%s.shaderAssignment' % assemby_name, data_str, type='string')
        shading_plug.setLocked(True)