import os

import maya.cmds as cmds
import maya.OpenMaya as OpenMaya

import maya_assemblies.lib.representations.representation as representation

import maya_assemblies.lib.helpers as helpers
import maya_assemblies.lib.shader_helpers as shader_helpers


class GpuRepresentation(representation.Representation):
    typename = "GpuRepresentation"
    def activate(self):
        assembly_name = self.get_assembly_name()
        gpu_cache = cmds.createNode('gpuCache', parent=assembly_name)
        cmds.setAttr(gpu_cache + '.cacheFileName', self.path, type='string')

        object_gpu_cache = helpers.get_mobject(gpu_cache)
        fn_gpu_cache = OpenMaya.MFnDependencyNode(object_gpu_cache)

        cache_plug = fn_gpu_cache.findPlug('cacheFileName')
        cache_plug.setLocked(True)
        self.loaded_nodes = [gpu_cache]
        shader_path = self.assembly.shader_path
        self.apply_shaders(shader_path)

        return True

    def can_apply_edits(self):
        return False


    def apply_shaders(self, shader_path):
        if not hasattr(self, 'loaded_nodes') or not self.loaded_nodes:
            return
        if shader_path and os.path.exists(shader_path):
            shader_helpers.apply_shaders(self.assembly, shader_path, self.loaded_nodes)
