import os
import maya.mel as mel

import maya.cmds as cmds

import maya_assemblies.lib.representations.representation as representation


class AudioRepresentation(representation.Representation):
    typename = 'Audio'

    def activate(self):
        node = cmds.sound(file = self.path)
        cmds.setAttr('%s.offset' % node, 1001)

        gPlayBackSlider = mel.eval('$tmpVar=$gPlayBackSlider')
        cmds.timeControl(gPlayBackSlider, edit=True, sound=node)

        return True

    def can_apply_edits(self):
        return False