import os
import importlib

import maya.cmds as cmds

import maya_assemblies.lib.representations.representation as representation
import maya_assemblies.lib.shader_helpers as shader_helpers

importlib.reload(shader_helpers)


class AbcRepresentation(representation.Representation):
    typename = "AbcRepresentation"

    def activate_geometry(self, geometry_path):
        assembly_name = self.get_assembly_name()
        namespace = self.get_assembly_namespace()

        cmds.AbcImport(geometry_path, mode='import', reparent=assembly_name)

        return
        self.loaded_nodes = []
        loaded_nodes = cmds.namespaceInfo(namespace, ls=True)
        if loaded_nodes:
            self.loaded_nodes = ['%s:%s' % (namespace, node.split(':')[-1]) for node in loaded_nodes]

        for node in self.loaded_nodes:
            if cmds.nodeType(node) != 'transform':
                continue
            cmds.setAttr('%s.translate' % node, lock=1)

            cmds.setAttr('%s.rotate' % node, lock=1)

            cmds.setAttr('%s.scale' % node, lock=1)

            cmds.lockNode(node, lock=True)


    def activate(self):
        geometry_path = self.assembly.geometry_path
        shader_path = self.assembly.shader_path

        self.activate_geometry(geometry_path)
        #self.apply_shaders(shader_path)
        return True


    def apply_shaders(self, shader_path):
        return
        if not hasattr(self, 'loaded_nodes') or not self.loaded_nodes:
            return
        if shader_path and os.path.exists(shader_path):
            shader_helpers.apply_shaders(self.assembly, shader_path, self.loaded_nodes)
