import re
from functools import partial

import pymel.core as pm


# Constants

kReloadDefinition = 'Reload the assembly definition'
kAEOpenNSEditor = 'Open Namespace Editor'
kAEassemblyNamespace = 'Namespace'
kInvalidNamespace = 'Namespace name \'{}\' contains invalid characters.'


class AERigAssemblyTemplate(pm.ui.AETemplate):

    def __init__(self, nodename):
        self.beginScrollLayout()
        pm.mel.AEtransformMain(nodename)

        self.beginLayout('Asset', collapse=False)
        self.addControl('assetName')
        self.addControl('assetType')
        self.addControl('instanceNumber')

        self.endLayout()

        self.beginLayout('Assembly', collapse=False)
        self.addControl('representationNamespace')
        self.addControl('activeRepresentation')

        self.endLayout()

        self.beginLayout('Rig', collapse=False)
        self.addControl('rigPath')
        self.addControl('rigVariant')
        self.addControl('rigVersion')
        self.addControl('rigHash')
        self.endLayout()

        self.endLayout()
        self.beginLayout('Shading', collapse=False)
        self.addControl('shadingPath')
        self.addControl('shadingVariant')
        self.addControl('shadingVersion')
        self.addControl('shadingHash')

        self.endLayout()


        pm.mel.AEtransformNoScroll(nodename)
        self.addExtraControls()

        # suppresses attributes

        self.suppress('assemblyEdits')
        self.suppress('blackBox')
        self.suppress('rmbCommand')
        self.suppress('templateName')
        self.suppress('templatePath')
        self.suppress('viewName')
        self.suppress('iconName')
        self.suppress('viewMode')
        self.suppress('templateVersion')
        self.suppress('uiTreatment')
        self.suppress('customTreatment')
        self.suppress('creator')
        self.suppress('creationDate')
        self.suppress('containerType')
        self.suppress('publishedNode')
        self.suppress('publishedNodeInfo')
        self.suppress('publishedNodeType')
        self.endScrollLayout()
