import json
import maya.cmds as cmds

import maya_assemblies.lib.representations.representation as representation



class SetRepresentation(representation.Representation):
    typename = "SetRepresentation"

    def set_transform(self, node, data):
        cmds.setAttr('%s.translate' % node, *list(data['translate']), type='double3')
        cmds.setAttr('%s.rotate' % node, *list(data['rotate']), type='double3')
        cmds.setAttr('%s.scale' % node, *list(data['scale']), type='double3')

    def create_nodes(self, data, parent=None):
        node_type = data['type']
        node_name = data['name']
        if node_type == 'transform':
            this_node = cmds.createNode('transform', name=node_name, parent=parent)
            self.set_transform(this_node, data)
            for node_data in data.get('children', {}):
                self.create_nodes(node_data, this_node)

        elif node_type == 'Assembly':

            this_node = cmds.createNode('Assembly', name=node_name, parent=parent)
            cmds.setAttr('%s.assemblyType' % this_node, data['assemblyType'], type='string')
            cmds.setAttr('%s.path' % this_node, data['path'], type='string')

            cmds.setAttr('%s.shaderFilePath' % this_node, data['shader_path'], type='string')
            if data['assemblyType'] == 'Geometry':
                self.set_transform(this_node, data)


    def activate(self):
        assembly_name = self.get_assembly_name()
        if not self.path:
            return
        self.shader_connections = {}
        with open(self.path, 'r') as f:
            json_data = json.load(f)

        self.create_nodes(json_data, assembly_name)


        return True

    def can_apply_edits(self):
        return True

    @classmethod
    def register(cls):
        if not cmds.pluginInfo('AbcImport', query=True, loaded=True):
            cmds.loadPlugin('AbcImport', quiet=True)

