from PySide import QtCore, QtGui, QtWidgets

import library.ui.labeled as labeled


class SceneElements(labeled.LabeledWidget):
    arrange = 'vertical'
    textChanged = QtCore.Signal(str)

    def __init__(self, value, label, values=[], database=None, parent=None):
        labeled.LabeledWidget.__init__(self, value, label, parent=parent)
        self.database = database
        self.add_value_widget()
        if values:
            self.setValue(values)

    def add_value_widget(self):
        font = QtGui.QFont()
        font.setBold(True)
        if self.value is None :
            self.value = ''
        self.value_widget = QtWidgets.QTableWidget()

        headers = ['Type', 'id', 'Asset', 'Variant', 'Subset', 'Version', 'path']
        self.value_widget.setColumnCount(7)
        self.value_widget.setColumnWidth(0, 100)
        self.value_widget.setColumnWidth(1, 50)

        self.value_widget.setColumnWidth(2, 100)
        self.value_widget.setColumnWidth(3, 50)
        self.value_widget.setColumnWidth(4, 45)
        self.value_widget.setColumnWidth(5, 50)

        self.value_widget.setHorizontalHeaderLabels(headers)
        self.value_widget.verticalHeader().setVisible(False)
        self.layout.addWidget(self.value_widget)

        header = self.value_widget.horizontalHeader()
        header.setSectionResizeMode(6, QtWidgets.QHeaderView.ResizeMode.Stretch)

    def setValue(self, values):
        self.values = values
        if not values:
            self.value_widget.setRowCount(0)
            return
        self.value_widget.setRowCount(len(values))

        index = 0
        for item_value in values:
            self.value_widget.setItem(index, 0, QtWidgets.QTableWidgetItem(item_value['pipeline_step']))
            self.value_widget.setItem(index, 1, QtWidgets.QTableWidgetItem(str(item_value['shotgrid_id'])))
            self.value_widget.setItem(index, 2, QtWidgets.QTableWidgetItem(item_value['asset_name']))
            self.value_widget.setItem(index, 3, QtWidgets.QTableWidgetItem(item_value.get('variant', '')))
            self.value_widget.setItem(index, 4, QtWidgets.QTableWidgetItem(item_value.get('subset', '')))

            self.value_widget.setItem(index, 5, QtWidgets.QTableWidgetItem('%03d' % item_value['version']))
            self.value_widget.setItem(index, 6, QtWidgets.QTableWidgetItem(item_value['path']))

            index += 1

    def getValue(self):

        return self.values