
def string_distance(str1, str2):
    d = dict()
    for i in range(len(str1) + 1):
        d[i] = dict()
        d[i][0] = i
    for i in range(len(str2) + 1):
        d[0][i] = i
    for i in range(1, len(str1) + 1):
        for j in range(1, len(str2) + 1):
            d[i][j] = min(d[i][j - 1] + 1, d[i - 1][j] + 1, d[i - 1][j - 1] + (not str1[i - 1] == str2[j - 1]))
    return d[len(str1)][len(str2)]


def get_translator(wrong_alembic, wrong_rig):
    all_distances = {}
    for abc_node in wrong_alembic:
        for rig_node in wrong_rig:
            this_distance = string_distance(abc_node, rig_node)
            if this_distance not in all_distances:
                all_distances[this_distance] = {abc_node: rig_node}
            else:
                all_distances[this_distance][abc_node] = rig_node

    translator = {}
    for key in sorted(all_distances.keys()):
        for a_node, r_node in all_distances[key].items():
            if a_node not in translator:
                translator[a_node] = r_node

    return translator

def node_list_minus(list_a, list_b):
    minus_list = []

    for a_node in list_a:
        a_basename = a_node.split('|')[-1]
        a_basename = a_basename.split(':')[-1]
        found = False
        for b_node in list_b:
            b_basename = b_node.split('|')[-1]
            b_basename = b_basename.split(':')[-1]

            if b_basename == a_basename:
                found = True

        if not found and a_node:
            minus_list.append(a_basename)

    return minus_list

def fix_unmatch(current_list, new_list):
    wrong_current = node_list_minus(current_list, new_list)
    wrong_new_names = node_list_minus(new_list, current_list)

    translator = get_translator(wrong_current, wrong_new_names)

    return translator
