import maya.cmds as cmds


def in_view_message_builder(msg_list, colors_list=['yellow', 'grey']):
    colors_dict = {
        'yellow':'FFEF00',
        'orange':'FFAB00',
        'red':'FF0000',
        'blue':'00CDFF',
        'purple':'9100FF',
        'grey':'D4D4D4',
        'green':'00FF00',
        'white':'FFFFFF',
        'black':'000000',
        'fireBrick':'B22222'
    }
    msg = str()

    open_tag = '<&lt;span style="color:#{};"&gt;>'
    close_tag = '<&lt;/span&gt;>'

    for i, m in enumerate(msg_list):
        m = '{}{}{}'.format(open_tag.format(colors_dict.get(colors_list[i])), m, close_tag)
        msg += m

    cmds.inViewMessage(amg=msg, pos='midCenter', fade=True)


def user_input_text_dialog(ok_button=None, **kwargs):
    
    _kwargs = {'button': ['OK', 'Cancel'], 
               'defaultButton': 'OK'
               }
    _kwargs.update(kwargs)

    result = cmds.promptDialog(**_kwargs)
    
    if result == (ok_button or _kwargs['button'][0]):
        return cmds.promptDialog(query=True, text=True)


def user_message_popup(ok_buttons=None, **kwargs):
    _kwargs = {
        'title': 'Confirm window',
        'message': 'Are you sure?',
        'button': ['Yes', 'No'],
        'defaultButton': 'No'}
    
    _kwargs.update(kwargs)

    result = cmds.confirmDialog(**_kwargs)

    if result in (ok_buttons or _kwargs['button'][:1]):
        return result