import requests
import urllib3
COMPANY_SERVER = 'https://ws.aas.lan/read'


def to_yaml(stream):
    import yaml

    data = yaml.safe_load(stream.decode('utf-8'))
    return data


def get_file_data(endpoint):
    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
    headers = {"Authorization": "Bearer cd6112fa-8fd3-4749-b48c-2c62043504c5"}
    response = requests.get(endpoint, headers=headers, verify=False)
    data = to_yaml(response.content)
    if isinstance(data, str):
        return None
    return data


def read_config(config_path):
    endpoint = f'{COMPANY_SERVER}/{config_path}'
    data = get_file_data(endpoint)
    return data


if __name__ == '__main__':

    global_config = read_config('config/gitlab_tokens.yaml')