import re

class ReferencesSolver():
    def __init__(self, *args, **kargs ): #start_delimiter='<<', end_delimiter='>>'):

        self.start_delimiter = kargs.get('start_delimiter', '<')
        self.end_delimiter = kargs.get('end_delimiter', '>')

    @staticmethod
    def parse_dict(original_values, start_delimiter='<', end_delimiter='>', aditional_values={}, **kwargs):

        values = original_values.copy()
        solve_vars = ReferencesSolver(start_delimiter=start_delimiter, end_delimiter=end_delimiter)

        for key, value in values.items():
            if not isinstance(value, list):
                setattr(solve_vars, key.lower(), value)
            elif len(value) == 1:
                setattr(solve_vars, key.lower(), value[0])
            else:
                setattr(solve_vars, key.lower(), value)

        for key, value in aditional_values.items():
            setattr(solve_vars, key, value)

        vars_to_solve = {}
        for key, value in values.items():
            vars_to_solve[key.lower()] = value

        for key, value in aditional_values.items():
            vars_to_solve[key] = value

        solve_vars._vars_to_solve = vars_to_solve
        new_values = {}

        for key, value in values.items():
            new_value = getattr(solve_vars, key.lower())
            if isinstance(value, list) and not isinstance(new_value, list):
                new_values[key] = [new_value]
            else:
                new_values[key] = new_value

        return new_values


    def single_var_pattern(self, pattern):

        solved_name = pattern.replace(self.start_delimiter, '')
        solved_name = solved_name.replace(self.end_delimiter, '')

        if solved_name == pattern:
            return pattern
        if solved_name.find('.') > -1:
            node_name, attribute = solved_name.split('.', 1)

            if hasattr(self, node_name) and isinstance(getattr(self, node_name), dict):
                dictionary = getattr(self, node_name)
                return dictionary.get(attribute)


            elif hasattr(self, '_manager'):
                connected_node = self._manager.nodes.get(node_name)
                if not connected_node:
                    return pattern

                if hasattr(connected_node, attribute):
                    return getattr(connected_node, attribute)


            elif hasattr(self, 'siblings'):

                connected_node = self.siblings.get(node_name)
                if not connected_node:
                    return pattern
                
                if hasattr(connected_node, attribute):
                    return getattr(connected_node, attribute)

            return pattern

        elif hasattr(self, solved_name):
            output = getattr(self, solved_name)
            if isinstance(output, str):
                solved_value = self.solve_str_pattern(output)
                return solved_value
            
            elif isinstance(output, dict) or isinstance(output, list):
                return self.solve_variable(output)
            else:
                return output
        return pattern
    
    def replace_var_pattern(self, pattern, match_list):
        for match in match_list:
            value = self.single_var_pattern(match)
            if isinstance(value, str):
                pattern = pattern.replace(match, value)
        return pattern

        
    def solve_str_pattern(self, var_pattern):
        
        start_delimiter = self.start_delimiter
        end_delimiter = self.end_delimiter
        
        if start_delimiter == '[':
            start_delimiter = '\['

        if end_delimiter == ']':
            end_delimiter = '\]'

        search_pattern = r'%s[.0-9a-z_]*%s' % (start_delimiter, end_delimiter)
        all_matchs = re.findall(search_pattern, var_pattern)
        if not all_matchs:
            return var_pattern
        elif len(all_matchs) == 1 and all_matchs[0] == var_pattern:
            return self.single_var_pattern(all_matchs[0])
        else:
            return self.replace_var_pattern(var_pattern, all_matchs)


    def solve_variable(self, var_pattern):
        if isinstance(var_pattern, str):
            solved = self.solve_str_pattern(var_pattern)
            return solved
        
        elif isinstance(var_pattern, list):
            new_list = []
            for item in var_pattern:
                solved = self.solve_variable(item)
                new_list.append(solved)
            return new_list
        
        elif isinstance(var_pattern, dict):
            
            new_dict = {}
            for item, pattern in var_pattern.items():
                solved = self.solve_variable(pattern)
                new_dict[item] = solved
            return new_dict

        return var_pattern
    
    def __setattr__(self, variant, value):
        if variant[0] == '_':
            object.__setattr__(self, variant, value)
        
        elif hasattr(self, '_vars_to_solve') and variant in self._vars_to_solve:
            self._vars_to_solve[variant] = value
            object.__setattr__(self, variant, value)
        else:
            object.__setattr__(self, variant, value)

    def __getattribute__(self, variant):
        if variant[0] == '_':
            return object.__getattribute__(self, variant)

        elif hasattr(self, '_vars_to_solve') and variant in self._vars_to_solve:
            original_value = object.__getattribute__(self, variant)
            if original_value == variant:
                return variant
            new_value = self.solve_variable(original_value)
            return new_value
        else:
            return object.__getattribute__(self, variant)



if __name__ == '__main__':
    string = '[project_root]/[project]/config/apps'
