import logging
import argparse
import inspect

logger = logging.getLogger(__name__)

def get_args_kwards(funct):

    args = []
    kwargs = {}

    args_info = inspect.signature(funct)
    for arg, value in args_info.parameters.items():
        if arg == 'self':
            continue
        if value.default == inspect._empty:
            logger.debug('arg: %s' % arg)
            args.append(str(arg))
        else:

            logger.debug('kwargs: %s = %s' %(arg, value.default))
            kwargs[str(arg)] = value.default

    return args, kwargs

def parse_function(funct):
    """
    Read the header of the function and dynamically create the arparse instance to use the function as a command line

    :funct: The function to be launched as command line
    """

    args_info = inspect.getfullargspec(funct)
    help_lines = {}

    if funct.__doc__:
        description = funct.__doc__

        short_description = ''
        for line in description.split('\n'):
            if not line:
                continue
            bits = line.split(' ')
            argument = False
            for index, bit in enumerate(bits):
                if not bit:
                    continue
                if bit[-1] == ':':
                    help_lines[bit[:-1]] = ' '.join(bits[index+1:])
                    argument = True
            if not argument:
                short_description += '%s\n' % line
        description = short_description
    else:
        description = '%s command line' % funct.__name__

    parser = argparse.ArgumentParser(description=description)
    args_len = len(args_info.args)
    kwargs = {}

    if args_info.defaults:
        args_vals = len(args_info.defaults)
    
        pos = args_len - args_vals 

        args = args_info[0][:pos]
        kwars_keys = args_info[0][pos:]
        for key, value in zip(kwars_keys, args_info[3]):
            argument = key.replace('_', '-')
            kwargs[key] = value
            help ='%s  DEFAULT: %s' % (help_lines.get(key, key), value)

            parser.add_argument('--%s' % argument, dest=key, help=help, default=value)

    else:
        args = args_info.args

    for arg in args:
        if arg == 'self':
            continue
        argument = arg.replace('_', '-')

        help = help_lines.get(arg, arg)

        parser.add_argument('--%s' % argument, dest=arg, help=help, required=True)

    parsed_args = parser.parse_args()

    launch_args = []
    launch_kwargs = {}
    for arg in args:
        if arg == 'self':
            continue
        launch_args.append(getattr(parsed_args, arg))
    
    for arg in kwargs.keys():
        if hasattr(parsed_args, arg):
            logger.debug(arg, getattr(parsed_args, arg))
            launch_kwargs[arg] = getattr(parsed_args, arg)

    return_value = funct(*launch_args, **launch_kwargs)

    return return_value


if __name__ == '__main__':
    import sys
    sys.path.insert(0, r'c:/dev')
    import actions.system.copy_files as copy_files

    args, kwards = get_args_kwards(copy_files.copy_file)
