class ConfigNotFound(Exception):
    def __init__(self, config_file, module_name, message="The config file %s.yaml of module %s was not found"):
        self.config_file = config_file
        self.module_name = module_name
        self.message = message % (self.config_file, self.module_name)
        super().__init__(self.message)

class ProjectConfigNotFound(Exception):
    def __init__(self, project_name, message="The config file of the project %s"):
        self.project_name = project_name
        self.message = message % self.project_name
        super().__init__(self.message)