import importlib
import logging
from pprint import pprint

import library.core.parser_function as parser_function

logger = logging.getLogger(__name__)


def group_arguments(funct, script_data):
    """
    Read the function and package the given arguments in the args list and kwargs dict to be sent to the function
    """

    arguments = script_data.get('args', {})
    if not arguments:
        arguments = script_data.get('arguments', {})

    args, kwargs = parser_function.get_args_kwards(funct)
    solved_args = []
    for arg in args:
        if arg not in arguments:
            raise AttributeError
        solved_args.append(arguments[arg])
        logger.debug('args: %s = %s' % (arg, str(arguments[arg])))

    solved_kwargs = {}
    for arg, value in arguments.items():
        if arg in kwargs:
            solved_kwargs[arg] = value
            logger.debug('kwargs: %s = %s' % (arg, value))

    return solved_args, solved_kwargs
    
def get_function(script_data):
    """
    Get the function from the script data, first get the module and then the function/class

        :param script_data: is a dictionary setting the module, the function/class and also all the arguments as a dictionary

    """
    module_name = script_data['module']
    function_name = script_data.get('function', module_name)
    my_module = importlib.import_module(module_name)

    if not my_module:
        logger.error('Can\'t find module: %s ' %  module_name)
        return None
    
    importlib.reload(my_module)
    if hasattr(my_module, function_name):
        run_function = getattr(my_module, function_name)
    else:
        logger.error('Can\'t find  %s in module: %s ' %  (function_name, module_name))
        return None
    
    return run_function


def run_scripts(script_data):
    if not script_data or not isinstance(script_data, dict):
        return
    run_function = get_function(script_data)
    if not run_function:
        return 
    logger.debug('Running script:')

    args, kwargs = group_arguments(run_function, script_data)
    output = run_function(*args, **kwargs)

    return output


def demo01(argument_a, argument_b, argument_c='empty', argument_d=None):
    print('Running Dynamic Run demo with arguments')
    print('argument_a:', argument_a)
    print('argument_b:', argument_b)
    print('argument_c:', argument_c)
    print('argument_d:', argument_d)

    return 'finished OK'
