import os
import shutil
from pathlib import Path


def copy_module(repo_file_path, local_file_path):
    if os.path.isfile(repo_file_path):
        shutil.copy2(repo_file_path, local_file_path)
    elif os.path.isdir(repo_file_path):
        if os.path.exists(local_file_path):
            shutil.rmtree(local_file_path)
        shutil.copytree(repo_file_path, local_file_path)


def update_file(repo_file_path, local_file_path):
    remote_basename = os.path.basename(repo_file_path)
    if not os.path.exists(local_file_path):
        print(f'Copying file: {remote_basename}')
        copy_module(repo_file_path, local_file_path)
        return
    local_stats = os.stat(local_file_path)
    repo_stats = os.stat(repo_file_path)

    if repo_stats.st_mtime > local_stats.st_mtime:
        print(f'Updating file: {remote_basename}' )
        copy_module(repo_file_path, local_file_path)


def check_sitecustomize_files():
    print('Check python base libraries')
    repo_folder = Path('%s/tools/site_customize' % os.environ['COMPANY_ROOT'])
    local_folder = os.environ.get('TOOLS_ROOT')

    if not repo_folder.exists() or not local_folder or not os.path.exists(local_folder):
        return

    for remote_basename in os.listdir(repo_folder):
        repo_path = os.path.join(repo_folder, remote_basename)
        if not os.path.isfile(repo_path):
            continue
        local_file_path = os.path.join(local_folder, remote_basename)

        update_file(repo_path, local_file_path)


def get_python_path(repo_folder, python_version):
    path = repo_folder.joinpath(python_version)
    path = path.joinpath('Lib')
    path = path.joinpath('site-packages')
    return path


def update_libraries():

    repo_folder = Path(r'\\project\SGD\company\tools\python_libraries' )
    tools_root = Path(os.environ.get('TOOLS_ROOT'))
    local_folder = tools_root.joinpath('python')

    python_version = ['3.11', 'maya_3.11', 'maya_3.10']

    for python_version in python_version:
        repo_sitepackages_path = get_python_path(repo_folder, python_version)
        local_sitepackages_path = get_python_path(local_folder, python_version)
        if not os.path.exists(local_sitepackages_path):
            os.makedirs(local_sitepackages_path)
        print('Check python libraries: %s' % python_version)
        for element in os.listdir(repo_sitepackages_path):
            if element.endswith('dist-info'):
                continue
            repo_module = repo_sitepackages_path.joinpath(element)
            local_module = local_sitepackages_path.joinpath(element)
            update_file(repo_module, local_module)

if __name__ == '__main__':
    update_libraries()