import os
import sys
import importlib

import version_finders
WEBSOCKET = 'https://ws.aas.lan/read/config'

def get_websocket_config(config_path):
    import requests
    import urllib3
    import yaml

    urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
    endpoint = f'{WEBSOCKET}/{config_path}'
    headers = {"Authorization": "Bearer cd6112fa-8fd3-4749-b48c-2c62043504c5"}
    response = requests.get(endpoint, headers=headers, verify=False)
    data = yaml.safe_load(response.content.decode('utf-8'))
    return data


if __name__ == '__main__':

    global_config = version_finders.get_repo_config('global.yaml')

    default_project = global_config.get('default_project', 'tpt')
    default_versions = global_config.get('default_versions', {})

    default_libraries = []
    for key, value in default_versions.items():
        env_var_name = '%s_VERSION' % key.upper()
        if env_var_name not in os.environ:
            os.environ[env_var_name] = str(value)
            print('set default version: %s = %s' % (env_var_name, value))
            default_libraries.append(key)


    from PySide import QtWidgets

    import launcher.lib.tools_launcher_gui as tools_launcher_gui

    for module_name in default_libraries:
        print('checking :%s' % module_name)
        importlib.import_module(module_name)
    # check_sitecustomize_files()

    importlib.reload(tools_launcher_gui)
    app=QtWidgets.QApplication(sys.argv)
    window = tools_launcher_gui.ToolsLauncherWindow(project=default_project)
    tools_launcher_gui.apply_style(app)
    window.show()
    app.exec()
