import sys

from urllib.parse import urlparse, parse_qs

import library.core.dynamic_run as dynamic_run

if __name__ == '__main__':

    argument = sys.argv[1]
    argument_parse = urlparse(argument)

    arguments = parse_qs(argument_parse.query)
    clean_arguments = {}
    for key, value in arguments.items():
        value = value[0]
        if key.endswith('_id') and value.isdigit():
            value = int(value)
        elif key.endswith('_ids') or key == 'ids':
            value = [int(val) for val in value.split(',')]
        clean_arguments[key] = value

    bits = argument_parse.netloc.rsplit('.', 1)
    print(bits)
    module_name = bits[0]
    function_name = bits[1]

    function_data = {'module': module_name,
                     'function': function_name,
                     'args': clean_arguments}

    status = dynamic_run.run_scripts(function_data)

