import sys
import os
import importlib
import importlib.util as ip_util

from importlib.abc import MetaPathFinder, Loader


# os.environ['LIBRARY_VERSION'] = '1.0.0'
# os.environ['PUBLISHER_VERSION'] = '0.2.0'

class VersionedPathFinder(MetaPathFinder, Loader):

    def __init__(self, ):
        super(VersionedPathFinder, self).__init__()
        self.ignored_packages = ['python']
        self.local_tools_path = 'C:/pipe/tools'

        self.server_tools_path = 'V:/company/tools'
        if os.environ.get('LOCAL_DEPLOY', False):
            print('Using local deploy')
            self.tools_path = self.local_tools_path
        else:
            print('Using server deploy')
            self.tools_path = self.server_tools_path

        self.dev_path = 'C:/dev'
        self.repo_url = 'https://gitlab.com/inefecto-tnf/tara-project'

    def get_tool_from_repo(self, tool_name, tool_version):
        print('get from git', tool_name, tool_version)
        import subprocess
        repo_path = os.path.join(self.tools_path, tool_name, tool_version)

        current_repo = '%s/%s.git' % (self.repo_url, tool_name)
        command = 'git clone {} --branch {} --single-branch {}'.format(current_repo, tool_version, repo_path)
        print(command)
        subprocess.call(command)

        full_path = os.path.join(self.tools_path, tool_name, tool_version, '__init__.py')
        if os.path.exists(full_path):
            spec = importlib.util.spec_from_file_location(tool_name, full_path)
            return spec
        return None

    def find_spec(self, fullname, path, target=None):

        # extract module name from fullname
        bits = fullname.split(".")
        mod_name = bits[-1]
        package_name = bits[0]
        if package_name in self.ignored_packages:
            return
        version = os.environ.get('%s_VERSION' % package_name.upper())
        if not version:
            return None

        if version == 'local':
            tools_path = self.dev_path
        else:
            tools_path = self.tools_path
        # print(tools_path)
        # print('>>', fullname, package_name, version, tools_path)

        # path is None or a list of paths, we use os.curdir when it's None

        if len(bits) > 1:
            local_path = '/'.join(bits[1:])
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version, local_path)
            else:
                full_path = os.path.join(tools_path, package_name, local_path)
        else:
            if version != 'local':
                full_path = os.path.join(tools_path, package_name, version)
            else:
                full_path = os.path.join(tools_path, package_name)

        check_path = '%s.py' % full_path
        if os.path.exists(check_path):
            full_path = check_path
        else:
            full_path = os.path.join(full_path, '__init__.py')

        print(full_path, os.path.exists(full_path))

        if os.path.exists(full_path):
            spec = ip_util.spec_from_file_location(fullname, full_path)
            return spec

        elif len(bits) == 1 and version != 'local':
            print('should download')
            # return None
            spec = self.get_tool_from_repo(mod_name, version)
            return spec

        # return None to tell the python this finder can't find the module
        return None


def init():
    sys.meta_path.insert(0, VersionedPathFinder())


# init()
# insert a MyMetaPathFinder instance at the start of the meta_path list
if __name__ == '__main__':
    sys.meta_path.insert(0, VersionedPathFinder())

    # import library
    # print(library)
    # import library.core.parser_function as test
    # print(test)
    import publisher.bin.publisher_gui as pub_gui

    print(pub_gui)
