import os
import sys
import yaml
import importlib


if __name__ == '__main__':

    company_root = os.environ.get('COMPANY_ROOT', r'\\company\company')

    config_version_path = os.path.join(company_root, 'config', 'global.yaml')
    if not os.path.exists(config_version_path):
        print('Can\'t find the global config file. Can\'t open the launcher')
    with open(config_version_path) as f:
        global_config = yaml.load(f, Loader=yaml.SafeLoader)

    default_project = global_config.get('default_project', 'tpt')
    default_versions = global_config.get('default_versions', {})

    for key, value in default_versions.items():
        env_var_name = '%s_VERSION' % key.upper()
        if env_var_name not in os.environ:
            os.environ[env_var_name] = str(value)
            print('set default version: %s = %s' % (env_var_name, value))

    from PySide import QtWidgets

    import launcher.lib.tools_launcher_gui as tools_launcher_gui

    # check_sitecustomize_files()
    importlib.reload(tools_launcher_gui)
    app=QtWidgets.QApplication(sys.argv)
    window = tools_launcher_gui.ToolsLauncherWindow(project=default_project)
    tools_launcher_gui.apply_style(app)
    window.show()
    app.exec()
