import yaml
import logging
import importlib

from pprint import pprint
import shotgrid_lib.database as database
import library.core.config_manager as config_manager

#importlib.reload(database)


class StepDependencies():
    def __init__(self,
                 entity_name,
                 pipeline_step,
                 project='sgd',
                 variant='Master',
                 load_current=True,
                 only_approved=False):

        self.entity_name = entity_name
        self.pipeline_step = pipeline_step
        self.project = project
        self.current_variant = variant
        self.load_current = load_current
        self.only_approved = only_approved

        self.config_solver = config_manager.ConfigSolver(project=self.project)
        self.project_data = self.config_solver.get_config('project')
        self._vars_to_solve = {}
        config = '%s_dependencies' % pipeline_step
        print(config)
        self.dependencies = self.config_solver.get_config(config, module='dependency_tracker')
        print(self.dependencies)
        self.entity_type = self.dependencies['entity_type']

        self.database = database.DataBase()
        self.database.fill(project=self.project)
        self.step_nodes = {}
        self.step_info = {}
        if self.only_approved:
            self.approved_order = ['cmpt']
        else:
            self.approved_order = ['cmpt', 'rev', 'clsd', 'max']

        self.init_database()

    def init_database(self):
        print('Precaching database dependencies')

        if self.entity_type == 'Shot':
            if 'Shot' not in self.database.precached_entities:
                print('get shot data : %s' % self.entity_name)
                self.database.query_entity('Shot',
                                           filters=[['code', 'is', self.entity_name],],
                                           as_precache=True)

            self.entity_data = self.database.get_unique_record('Shot', code=self.entity_name)
            all_assets = [self.entity_name]
            for breakdown in self.entity_data.sg_breakdowns:
                all_assets.append(breakdown.sg_asset_name)

        else:
            print('get asset data')
            self.entity_data = self.database.get_unique_record('Asset', code=self.entity_name)
            all_assets = [self.entity_name]

        pre_filters = self.database.pre_filters.get('CustomEntity09', [['sg_complete', 'is', True], ['sg_delete', 'is', False]])

        self.database.query_entity('Asset',
                                   filters=[['code', 'in', all_assets],
                                            ],
                                   as_precache=True)

        asset_filters = pre_filters.copy()
        asset_filters.append(['sg_asset.Asset.code', 'in', all_assets])
        asset_filters.append(['sg_complete', 'is', True])
        asset_filters.append(['sg_delete', 'is', False])

        self.database.query_entity('CustomEntity09',
                                   filters=asset_filters,
                                   as_precache=True)
        if self.entity_type == 'Shot':
            shot_filters = pre_filters.copy()
            shot_filters.append(['sg_context.Shot.code', 'in', self.entity_name])
            shot_filters.append(['sg_complete', 'is', True])
            shot_filters.append(['sg_delete', 'is', False])
            self.database.query_entity('CustomEntity09',
                                       filters=shot_filters,
                                       as_precache=True)

        self.database.query_entity('CustomEntity11',
                                   filters=[],
                                   as_precache=True)

        self.database.query_entity('Step', [['entity_type', 'in', ['Asset', 'Shot']]], as_precache=True)

        self.job_types = self.database.cached_table('Step')

        print('done')


    def get_highest_item(self, item, pipeline_step, step_data):
        print(pipeline_step)

        step_view = self.database.entity_view('Step')[pipeline_step]
        step_context = step_view.entity_type

        print('item type', item.type)
        print('step data', step_data)
        if step_data:
            variant_type = step_data.get('variant', None)
        else:
            variant_type = ''

        variant_view = None
        all_variant_view = self.database.entity_view('CustomEntity11')

        if 'asset_name' in step_data:
            context = self.database.entity_view('Asset')[step_data['asset_name']]
            print(context)
            if 'variant' in step_data:
                variant_view = all_variant_view[step_data['variant']]

        elif item.type == 'Asset':
            context = item
        elif item.type == 'Shot':
            context = item
        elif item.type == 'CustomEntity12':
            if step_context == 'Shot':
                context = item.sg_link
                print('breakdown as Shot')
            else:
                print('breakdown as Asset')
                context = item.sg_asset
            if variant_type == 'geometry':
                variant_view = item.sg_geometry_variant
            else:
                variant_view = item.sg_shading_variant
        else:
            context = item

        if item.type == 'Asset':
            context_asset_type = context.sg_asset_type.split(' ')[-1]
            asset_type = step_data.get('asset_type')
            if context_asset_type != asset_type:
                return None
        if variant_view is None or variant_view.empty:
            variant_view = all_variant_view[self.current_variant]

        print(variant_view)
        publish_item = self.database.entity_view('Step').find_with_filters(code=pipeline_step,
                                                                           single_item=True)

        published = context.sg_published_elements.find_with_filters(sg_step=publish_item,
                                                                  # sg_status_list='cmpt',
                                                                    sg_complete=True,
                                                                    sg_delete=False,
                                                                    sg_variant=variant_view
                                                                    )

        if published and not published.empty:
            return max(published)

        return database.emptyView()

    def entity_version_to_dict(self, entity, version, step_name):
        step_info = {'step': step_name,
                     'type': self.entity_type,
                     'code': entity.code,
                     }

        if self.entity_type == 'Shot':
            step_info['start_frame'] = entity.sg_cut_in
            step_info['end_frame'] = entity.sg_cut_out
            step_info['shot'] = entity.code

        else:
            step_info['asset_type'] = entity.sg_asset_type

        if version:
            step_info['published_folder'] = version.sg_published_folder
            step_info['id'] = 'CustomEntity09:%s' % version.id
            step_info['files'] = version.sg_files
            step_info['version_number'] = version.sg_version_number
            step_info['hash'] = version.sg_hash

            if isinstance(version.sg_status_list, database.emptyView):
                step_info['status'] = ''
            else:
                step_info['status'] = version.sg_status_list
            step_info['variant'] = version.sg_variant_name

            if self.entity_type == 'Asset':

                step_info['code'] = version.sg_asset.code
                step_info['asset_type'] = version.sg_asset.sg_asset_type

        return step_info


    def get_context_data(self):
        shot_elements = []
        context_dependencies = self.dependencies['context']

        if not context_dependencies:
            return

        for asset_type, asset_type_data in context_dependencies.items():
            for global_step_data in asset_type_data:
                print('----')
                global_step, global_data = list(global_step_data.items())[0]
                if global_data is None:
                    global_data = {}

                global_data['asset_type'] = asset_type
                if global_step != self.pipeline_step or self.load_current:
                    version = self.get_highest_item(self.entity_data, global_step, global_data)
                    if version is not None:
                        shot_elements.append(self.entity_version_to_dict(self.entity_data, version, global_step))

        self.step_info['context'] = shot_elements

if __name__ == '__main__':

    context_name = 's00_ep00_sq010_sh010'
    pipeline_step = 'Layout'
    #pipeline_step = 'tt_shading'

    #context_name = 'LeoMesi'
    #pipeline_step = 'Shading'

    step_node = StepDependencies(context_name, pipeline_step, load_current=True)
