import logging

from deadline_lib.lib.script.DeadlineConnect import DeadlineCon as Connect

import library.core.config_manager as config_manager
import library.core.references_solver as references_solver

logger = logging.getLogger(__name__)

def init_connection(project=None):

    config_mng = config_manager.ConfigSolver(project=project)
    deadline_settings = config_mng.get_config('repository', module='deadline_lib')
    deadlineConnection = Connect(deadline_settings['server_url'], deadline_settings['server_port'] )

    deadlineConnection.EnableAuthentication( True )
    deadlineConnection.SetAuthenticationCredentials( username = deadline_settings['user_name'],
                                                     password = deadline_settings['password'], enable = True )
    return deadlineConnection



class FarmJob(references_solver.ReferencesSolver):
   
    def __init__(self, project, plugin_type):
        super().__init__(self,)
        
        self.project = project
        self.plugin_type = plugin_type
        
        self.job_name = None
        self.batch_name = None
        self.chunk_size = 10
        self.frames = '1'
        self.comment = 'comment'
        self.department = 'td'
        self.group = None
        self.is_frame_dependent = False
        self.job_dependencies = []
        self._vars_to_solve = {}
        self.init_summiter()


    def init_summiter(self):
        self.connection = self.create_connection()
        self.config_manager = config_manager.ConfigSolver(project=self.project)
        self.project_config = self.config_manager.project_config
        self.submitter_config = self.config_manager.get_config('jobs_config', module='deadline')
        if self.plugin_type in self.submitter_config:
            self.job_config = self.submitter_config[self.plugin_type]['job_config'].copy()
            self.plugin_config = self.submitter_config[self.plugin_type]['plugin_config'].copy()
            self._vars_to_solve['job_config'] = self.job_config
            self._vars_to_solve['plugin_config'] = self.plugin_config
            

    def create_connection(self):
        #deadline_connection = Connect('192.168.1.38', 8081)
        deadline_connection = init_connection(self.project)


        return deadline_connection

    def get_pools(self):
        return 'trf-workers', None
    
    def get_limits(self):

        return None

    def get_job_priority(self):
        return 50

    def is_solved(self, variable, value):
        error = False
        if value is None:
            error = True
            print('error in key, not set: %s' % variable)

        if isinstance(value, str) and value and  value[0] == '<' and value[-1] == '>':
            error = True
            print('error in key, not solved: %s' % variable)
        
        return error

    def check_plugin_config(self):
        error = False
        for key, value in self.plugin_config.items():
            value_error = self.is_solved(key, value)
            error = error or value_error

        return error

    def launch_job(self):
        self.priority = self.get_job_priority()
        self.pool, self.secondary_pool = self.get_pools()
        self.limits = self.get_limits()
        self.job_dependencies = ','.join(self.job_dependencies)

        not_fullfilled = self.check_plugin_config()
        if not_fullfilled:
            print('ERROR')


if __name__ == '__main__':
    """
    dl_s = FarmJob('sgd', 'AACommandLine')
    dl_s.job_name = 'test launcher'
    dl_s.batch_name = 'batch name'
    dl_s.arguments = ''
    dl_s.executable = 'test_tool.py'
    dl_s.standalone = 'mayapy'
    
    dl_s.launch_job()
    """
    connection = init_connection('sgd')