
def solve_values(action_data, builder_args):
    solved_dict = {}
    for act_key, act_value in action_data.items():
        if isinstance(act_value, dict):
            solved_dict[act_key] = solve_values(act_value, builder_args)

        elif isinstance(act_value, str):
            for arg_name, arg_value in builder_args.items():
                if not isinstance(arg_value, str):
                    if arg_name == 'version_number':
                        arg_value = '%03d' % arg_value
                    else:
                        arg_value = str(arg_value)
                act_value = act_value.replace('<<%s>>' % arg_name, arg_value)
            solved_dict[act_key] = act_value
        else:
            solved_dict[act_key] = act_value
    return solved_dict

def build_template_nodes(data, parent=None):
    import maya.cmds as cmds

    if isinstance(data, dict):
        for name, value in data.items():
            node = cmds.createNode('transform', n=name, parent=parent)
            build_template_nodes(value, parent=node)
    elif isinstance(data, list):
        for name in data:
            cmds.createNode('transform', n=name, parent=parent)
    else:
        cmds.createNode('transform', n=data, parent=parent)


def build_template_sets(data, parent=None):
    import maya.cmds as cmds

    if isinstance(data, dict):
        for name, value in data.items():
            set_name = cmds.sets(n=name, em=True)
            if parent:
                cmds.sets(set_name, edit=True, fe=parent)
            build_template_sets(value, parent=set_name)

    elif isinstance(data, list):

        for name in data:
            set_name = cmds.sets(n=name, em=True)
            if parent:
                cmds.sets(set_name, edit=True, fe=parent)

    else:
        set_name = cmds.sets(n=data, em=True)
        if parent:
            cmds.sets(set_name, edit=True, fe=parent)


def create_template(task_type='', project=None):
    import library.core.config_manager as config_manager
    config_solver = config_manager.ConfigSolver(project=project)
    templates_data = config_solver.get_config('scene_template', module='builder')
    build_data_nodes = templates_data.get(task_type, {}).get('nodes')
    build_data_sets = templates_data.get(task_type, {}).get('sets')

    if build_data_nodes:
        build_template_nodes(build_data_nodes)
    if build_data_sets:
        build_template_sets(build_data_sets)
