
import importlib
import maya.cmds as cmds

import publisher.lib.publish_cmd as publish_cmd
import library.ui.dialog_widgets as dialog_widgets
from library.maya.gui_lib import user_message_popup


def publish_uvs(task_view=None, project='', geometry='asset'):
    tittle = f'Publish UVs in asset: {task_view.entity.code}'
    msg = "This action will publish the UVs and override the ones of modelling.\n"
    msg += "Do you want to continue?"
    user_decision = user_message_popup(**{'title': f'{tittle}',
                                        'message': f'{msg}',
                                        'button': ['Yes', 'No'],
                                        'defaultButton': 'No'})
    
    if not user_decision:
        return

    entity = task_view.entity
    asset_name = entity.code
    asset_type = entity.sg_asset_type
    task_code = task_view.content
    entity.precache_dependencies(fields=['tasks'])
    model_variant = cmds.getAttr('|asset.model_variant')
    
    for task in entity.tasks:
        if task.sg_variant_name == model_variant and task.step_name == 'Model' and task.sg_status_list != '':
            task_code = task.content

    source_path = cmds.file(q=True, sn=True)
    source_path_extension = source_path.split('.')[-1]

    parameters = {'geometry': geometry,
                  'task_code': task_code,
                  'entity_name': asset_name,
                  'asset_name': asset_name,
                  'asset_type': asset_type,
                  'entity_type': 'Asset',
                  'source_path': source_path,
                  'source_path_extension': source_path_extension,
                  'edit_step': 'UVs'}

    publisher = publish_cmd.PublishCmd('uvs', parameters, project=project)

    msg = f"Version {publisher.published_version.sg_version_number} of UV's, published under asset: {asset_name}."
    
    dialog = dialog_widgets.CustomDialog(None, 
                                        "UV's Published sucessfully!!", 
                                        msg)
    dialog.exec_()