import maya.cmds as cmds
import maya.mel as mel

cmds.optionVar(intValue=("redshiftBakeMode", 2))
cmds.optionVar(intValue=("redshiftSkipObjectsWithoutBakeSets", 0))
cmds.optionVar(intValue=("redshiftBakeDefaultsWidth", 256))
cmds.optionVar(intValue=("redshiftBakeDefaultsHeight", 256))
cmds.optionVar(intValue=("redshiftBakeDefaultsTileMode", 4))
cmds.optionVar(stringValue=("redshiftBakeDefaultsUvSet", 'map1'))
cmds.optionVar(intValue=("redshiftBakeDefaultsAutoTileCount", True))

cmds.optionVar(intValue=("redshiftBakeDefaultsNumTilesU", 2))
cmds.optionVar(intValue=("redshiftBakeDefaultsNumTilesV", 10))

cmds.setAttr('redshiftOptions.imageFormat', 2)

folder = r'C:\Users\fernando.vizoso\Documents\maya\projects\sourceimages'

shader_paths = {}
for sg_node in cmds.ls(type='shadingEngine'):
    connections = cmds.listConnections(sg_node, s=True, d=False)

    list_meshes = [mesh for mesh in connections if cmds.nodeType(mesh) == 'mesh' or cmds.nodeType(mesh) == 'transform']
    print(sg_node, list_meshes)
    if not list_meshes:
        continue
    cmds.select(list_meshes, r=True)
    longest_bit = None
    for bit in sg_node.split('_'):
        if longest_bit is None or len(bit) > len(longest_bit):
            longest_bit = bit

    full_path = '%s/%s' % (folder, longest_bit)

    cmds.setAttr('redshiftOptions.imageFilePrefix', full_path, type='string')
    cmds.setAttr('redshiftOptions.GIEnabled', 0)

    cmds.setAttr('defaultRenderGlobals.imageFilePrefix', full_path, type='string')
    print(full_path)

    shader_paths[sg_node] = {'path': full_path, 'nodes': list_meshes}
    cmds.rsRender(bake=True)

for sg_node, assign_data in shader_paths.items():
    full_path = assign_data['path']
    new_shader_node = cmds.shadingNode('standardSurface', n='%s_SG' % longest_bit, asShader=True)

    print('New node', new_shader_node)
    cmds.connectAttr('%s.outColor' % new_shader_node, '%s.surfaceShader' % sg_node, f=True)

    new_file_node = cmds.shadingNode('file', n='%s_file' % longest_bit, asShader=True)

    cmds.connectAttr('%s.outColor' % new_file_node, '%s.baseColor' % new_shader_node, f=True)

    cmds.setAttr('%s.specular' % new_shader_node, 0.0)

    cmds.setAttr('%s.fileTextureName' % new_file_node, '%s.1001.png' % full_path, type='string')
    cmds.setAttr('%s.uvTilingMode' % new_file_node, 3)
    cmds.setAttr('%s.uvTileProxyQuality' % new_file_node, 1)
    cmds.setAttr('%s.ignoreColorSpaceFileRules' % new_file_node, 1)

    cmds.setAttr('%s.colorSpace' % new_file_node, 'ACEScg', type='string')

