import os
import logging

logger = logging.getLogger(__name__)

def export_rig(root='', target=''):
    import maya.cmds as cmds

    dirname = os.path.dirname(target)
    if not os.path.exists(dirname):
        os.makedirs(dirname)
    logger.info('Start Export Rig')
    cmds.select(root, hi=True)
    all_controllers = cmds.ls(type='controller')

    cmds.select(all_controllers, add=True)
    cmds.select('Rig_Sets', add=True, noExpand=True)
    cmds.file(target, exportSelected=True, force=True, type='mayaBinary')
    logger.info('DONE Export Rig')
    return {'root': root, 'target': target}


if __name__ == '__main__':
    import argparse
    logger.info('running export rig')
    parser = argparse.ArgumentParser(description='Shotgun event launcher')

    parser.add_argument('-o', '-output', '--output-file', dest='output', help='Output file path')
    parser.add_argument('-r', '-root', '--root-geo', dest='root', help='Root geometry')

    args = parser.parse_args()

    import maya.standalone as standalone
    standalone.initialize(name='python')


    rig_folder = os.path.dirname(args.output)
    if not os.path.exists(rig_folder):
        os.makedirs(rig_folder)

    export_rig(root=args.root, target=args.output)