import maya.cmds as cmds

from library.maya.gui_lib import in_view_message_builder

def set_as_invisible_component():
    selection = cmds.ls(selection=True, flatten=True)

    if not selection:
        in_view_message_builder(['ERROR:', 
                                '  No selection!!\n', 
                                'Please select any face to add to it to the set.'],
                                ['red', 'orange', 'grey'])
        return
    elif not cmds.objExists('invisible_faces'):
        in_view_message_builder(['ERROR:', 
                                '  The set "invisible_faces" not exists!!\n', 
                                'Rebuild the scene to get the Model sets or create them.'],
                                ['red', 'orange', 'grey'])
        return
        
    for obj in selection:
        if obj.split(".")[-1].startswith('vtx'):
            in_view_message_builder(['ERROR:', 
                                     '  Invalid selection!!\n', 
                                     'Vertex are not allowed in this set.'],
                                     ['red', 'orange', 'grey'])
            return
        elif not cmds.objectType(obj) == 'mesh':
            in_view_message_builder(['ERROR:', 
                                     '  Invalid selection!!\n', 
                                     'Only mesh or mesh faces are allowed in this set.'],
                                     ['red', 'orange', 'grey'])
            return
        
    for node in selection:
        cmds.sets(node, e=True, forceElement='invisible_faces')
 
    in_view_message_builder(['SUCCESS:', 
                             '  Action done.\n', 
                             f'{str(len(selection)) } node/s added to invisible_faces set.'],
                             ['green', 'green', 'grey'])
    



