import logging
from pprint import pprint

import maya.cmds as cmds

from actions.maya.general import maya_sets_usd_collections as maya_inputs


logger = logging.getLogger(__name__)

def load_geometry_model(step_data=None, project='', current_step=''):
    logger.info('== Running Load geometry model ==')
    import library.core.config_manager as config_manager
    import usd.lib.usd_manager as usd_manager

    asset_name = step_data['code']
    asset_type = step_data['asset_type'].replace(' ', '_')
    config_solver = config_manager.ConfigSolver(project=project)
    templates_data = config_solver.get_config('scene_template', module='builder')
    project_config = config_solver.project_config
    usd_publish_path = project_config['paths']['usd_files']
    pipeline_step = current_step if current_step else step_data['step']

    proxy_geo = templates_data[pipeline_step].get('proxy_geo')
    render_geo = templates_data[pipeline_step].get('render_geo')

    asset_folder = step_data['published_folder']

    # usd_file = step_data['files'].get('usd')
    # full_path = '%s/%s' % (asset_folder, usd_file)
    # full_path = '%s/assets/%s/%s/geometry/%s_geometry.usda' % (usd_publish_path, asset_type, asset_name, asset_name)

    manager = usd_manager.UsdManager(project)
    manager.set_entity(asset_name, 'Asset', asset_type=asset_type)
    full_path = manager.get_layer_filename('geometry')
    manager.open(full_path)
    logger.info(f'Loading geometry from {full_path}')

    render_prim = '/asset/render'
    proxy_prim = '/asset/proxy'
    if proxy_geo and cmds.objExists(proxy_geo):
        print('proxy geo exists, loading')
        parent_node = cmds.listRelatives(proxy_geo, parent=True)
        cmds.delete(proxy_geo)
        cmds.mayaUSDImport(file=full_path, primPath=proxy_prim, parent=parent_node[0])
        cmds.setAttr('|asset|proxy.visibility', 0)

    if render_geo and cmds.objExists(render_geo):
        print('render geo exists, loading')

        parent_node = cmds.listRelatives(render_geo, parent=True)
        cmds.delete(render_geo)
        cmds.mayaUSDImport(file=full_path, primPath=render_prim, parent=parent_node[0])

    cmds.addAttr('|asset', longName='asset_name', dataType='string')
    cmds.setAttr('|asset.asset_name', step_data['code'], type='string')

    cmds.addAttr('|asset', longName='asset_type', dataType='string')
    cmds.setAttr('|asset.asset_type', step_data['asset_type'], type='string')

    cmds.addAttr('|asset', longName='model_variant', dataType='string')
    cmds.setAttr('|asset.model_variant', step_data['variant'], type='string')

    cmds.addAttr('|asset', longName='model_version', dataType='string')
    cmds.setAttr('|asset.model_version', step_data['version_number'], type='string')

    maya_inputs.usd_collection_to_maya_set(manager)