import json
import pickle
import maya.cmds as cmds

from pprint import pprint

import usd.lib.usd_manager as usd_manager


def export_uvs(asset_name,
               asset_type,
               output_path='',
               project='',
               geometry='',
               variant='',
               version=0,
               shotgrid_id=0):
    if not cmds.objExists(geometry):
        return

    print('PATH', output_path)
    cmds.select(geometry, r=True)
    options = ';exportUVs=1;exportSkels=none;exportSkin=none;exportBlendShapes=0;exportDisplayColor=0;;exportColorSets=1;exportComponentTags=1;defaultMeshScheme=catmullClark;animation=0;eulerFilter=0;staticSingleSample=0;startTime=1;endTime=1;frameStride=1;frameSample=0.0;defaultUSDFormat=usda;parentScope=;shadingMode=useRegistry;convertMaterialsTo=[];exportRelativeTextures=automatic;exportInstances=1;exportVisibility=1;mergeTransformAndShape=1;stripNamespaces=1;worldspace=0'
    cmds.file(output_path, options=options, typ='USD Export', es=True, pr=True)
    manager = usd_manager.UsdManager(project)
    manager.set_entity(asset_name, 'Asset', asset_type=asset_type)
    manager.open(output_path)

    for prim in manager.stage.Traverse():
        prim_type = prim.GetTypeName()
        prim_path = prim.GetPath().pathString
        if prim_type != 'Mesh' or not prim_path.startswith('/asset/render'):
            continue

        proxy_path = prim_path.replace('/asset/render', '/asset/proxy')
        proxy_prim = manager.stage.GetPrimAtPath(proxy_path)

        if not proxy_prim.IsValid():
            continue

        render_points = manager.get_attribute(prim, 'points')
        proxy_points = manager.get_attribute(proxy_prim, 'points')
        if render_points != proxy_points:
            continue


        render_fvc = manager.get_attribute(prim, 'faceVertexCounts')
        proxy_fvc = manager.get_attribute(proxy_prim, 'faceVertexCounts')
        if render_fvc != proxy_fvc:
            continue

        render_fvi = manager.get_attribute(prim, 'faceVertexIndices')
        proxy_fvi = manager.get_attribute(proxy_prim, 'faceVertexIndices')
        if render_fvi != proxy_fvi:
            continue

        print('equal proxy mesh, copying uvs', prim.GetName())

        source_st = manager.get_attribute(prim, 'primvars:st')
        source_st_indices = manager.get_attribute(prim, 'primvars:st:indices')
        manager.set_attribute(proxy_prim, attribute_name='primvars:st', value=source_st)
        manager.set_attribute(proxy_prim, attribute_name='primvars:st:indices', value=source_st_indices)

    manager.remove_attributes('uv')

    manager.set_default_prim('/asset')

    manager.asset_info = {'asset_name': asset_name,
                          'asset_type': asset_type,
                          'uv_variant': variant,
                          'uv_version': version,
                          'uv_shotgrid_id': shotgrid_id,
                          'uv_publish_path': output_path
                          }

    print(manager.filename)
    manager.save_stage()