import os
import pymupdf

import numpy as np
from PIL import  Image
import fitz

this_folder = os.path.dirname(os.path.abspath(__file__))
resources_folder = os.path.abspath(os.path.join(this_folder, '../resources'))

def pix2np(pix):
    im = np.frombuffer(pix.samples, dtype=np.uint8).reshape(pix.h, pix.w, pix.n)
    im = np.ascontiguousarray(im[..., [2, 1, 0]])  # rgb to bgr
    return im

def pdf_format(pdf_file, new_pdf):
    if not os.path.exists(pdf_file):
        raise FileNotFoundError('The psd file %s can\'t be found' % pdf_file)

    background_image = os.path.join(resources_folder, 'background_pdf.png')

    pdf_doc = fitz.open(pdf_file)
    total_pages = len(pdf_doc)
    img_xref = 0
    for i in range(0, total_pages):
        page = pdf_doc[i]
        mat = fitz.Matrix(1, 1)
        pix = page.get_pixmap(matrix=mat)

        im = pix2np(pix)

        empty_image = Image.new("RGBA", (pix.w, pix.h), (0, 0, 0, 0))


        page.clean_contents()
        img_xref = page.insert_image(page.rect,
                                     filename=background_image,
                                     overlay=True,
                                     keep_proportion=False,
                                     xref=img_xref)

        p = pymupdf.Point(200, 770)  # start point of 1st line
        text = "Updated pdf and added background: %s/%s" % (i+1, total_pages)
        rc = page.insert_text(p,  # bottom-left of 1st char
                              text,  # the text (honors '\n')
                              fontname="helv",  # the default font
                              fontsize=10,  # the default font size
                              rotate=0,  # also available: 90, 180, 270
                              color=(.5, .5, .8),
                              overlay=True
                              )

        rect_text = fitz.Rect(195, 760, 400, 777)
        shape = page.new_shape()
        shape.draw_rect(rect_text)
        shape.finish(color=(.5, .5, .8), width=1)
        shape.commit(overlay=True)

    pdf_doc.save(new_pdf, garbage=4, deflate=True, clean=True)


pdf_file = 'C:/projects/Alembic_cache_workflow.pdf'
new_pdf = 'C:/projects/formated_Specs.pdf'
pdf_format(pdf_file, new_pdf)

