import os
import shutil

import logging
logger = logging.getLogger(__name__)


FOLDERS = {'mov': 'video',
           'mp4': 'video',
           'pdf': 'document',
           'mp3': 'audio',
           'wav': 'audio',
           'jpg': 'image',
           'png': 'image',
           'gif': 'image'}


def save_in_maya():
    import maya.cmds as cmds

    cmds.file(s=True, force=True)

def copy_file(source, target, maya_save=False):
    import time
    logger.info('Running copy')
    if maya_save:
        save_in_maya()

    if not os.path.exists(source):
        logger.warning('Can\'t find source file: %s' % source)
        return {}
    logger.info(target)
    dirname = os.path.dirname(target)
    
    if not os.path.exists(dirname):
        logger.info('creating target folder : %s' % dirname)

        os.makedirs(dirname)

    shutil.copy2(source, target)
    while not os.path.exists(target):
        time.sleep(5)

    logger.info('Copy DONE!!')
    return {'source': source,
            'target': target}


def copy_file_dict(source_dict, target_folder, publish_folder='', add_type_folder=False):
    print('PUBLISH FOLDER', publish_folder)
    output_files = {}
    len_publish_folder = len(publish_folder)
    if len_publish_folder:
        len_publish_folder += 1
    for tag, source_path in source_dict.items():
        extension = source_path.split('.')[-1]
        if add_type_folder:
            type_folder = FOLDERS.get(extension.lower(), 'all')
            full_path = '%s/%s/%s.%s' % (target_folder, type_folder, tag, extension)

        else:
            full_path = '%s/%s.%s' % (target_folder, tag, extension)

        dirname = os.path.dirname(full_path)

        if not os.path.exists(dirname):
            os.makedirs(dirname)

        copy_file(source_path, full_path)

        output_files[tag] = full_path[len_publish_folder:]

    return {'output_files': output_files}


if __name__ == '__main__':
    import argparse

    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-s', '-source', '--source-file', dest='source', help='Source file path')
    parser.add_argument('-t', '-target', '--target-file', dest='target', help='Target file path')

    args = parser.parse_args()

    copy_file(source=args.source, target=args.target)


