
import importlib
import maya.cmds as cmds

import publisher.lib.publish_cmd as publish_cmd
importlib.reload(publish_cmd)

def publish_uvs(task_view=None, project='', geometry='asset'):

    entity = task_view.entity
    asset_name = entity.code
    asset_type = entity.sg_asset_type
    task_code = task_view.content
    entity.precache_dependencies(fields=['tasks'])
    model_variant = cmds.getAttr('|asset.model_variant')
    print(model_variant)
    print(entity)
    for task in entity.tasks:
        if task.sg_variant_name == model_variant and task.step_name == 'Model' and task.sg_status_list != '':
            task_code = task.content

    source_path = cmds.file(q=True, sn=True)
    source_path_extension = source_path.split('.')[-1]

    parameters = {'geometry': geometry,
                  'task_code': task_code,
                  'entity_name': asset_name,
                  'asset_name': asset_name,
                  'asset_type': asset_type,
                  'source_path': source_path,
                  'source_path_extension': source_path_extension,
                  'edit_step': 'UVs'}

    publisher = publish_cmd.PublishCmd('uvs', parameters, project=project)