import ast
from pprint import pprint
import importlib
import maya.cmds as cmds

import library.core.config_manager as config_manager
import library.core.string_distance as string_distance

ASSET_NODES={'Cameras': {'suffix': 'CAM', 'group':'Camera'},
             'Main Characters': {'suffix': 'CHAR', 'group':'Characters'},
             'Secondary Characters': {'suffix': 'CHAR', 'group': 'Characters'},
             'Setprops': {'suffix': 'PROP', 'group': 'Props'},
             'Sets': {'suffix': 'SET', 'group':'Sets'},
        }


def apply_shader(step_data=None, project=None, current_step=''):

    project = project
    asset_name = step_data['code']

    asset_folder = step_data['published_folder']
    asset_file = step_data['files']['shaders']

    config_solver = config_manager.ConfigSolver(project=project)
    project_config = config_solver.project_config

    renderer = project_config['renderer']
    shading_config = config_solver.get_config('shading_config', module='builder')
    shading_info_attribute = shading_config['shading_info_attribute']
    full_asset_path = '%s/%s' % (asset_folder, asset_file)
    try:
        cmds.file(full_asset_path, i=True)
    except:
        pass

    shaders_to_apply = []
    geo_to_apply = []
    for sg_name in cmds.ls(type='shadingEngine'):
        if not cmds.attributeQuery(shading_info_attribute, node=sg_name, exists=True):
            continue
        shaders_to_apply.append(sg_name)
        sg_data_raw = cmds.getAttr('%s.%s' % (sg_name, shading_info_attribute))
        sg_data = ast.literal_eval(sg_data_raw)
        for node_name in sg_data:
            geo_to_apply.append(node_name)

    current_geos = []
    for geo_node in cmds.ls(type='mesh'):
        parent_node = cmds.listRelatives(geo_node, parent=True)
        current_geos.append(parent_node[0])


    if not shaders_to_apply:
        return
    translator_data = string_distance.fix_unmatch(geo_to_apply, current_geos)

    if len(shaders_to_apply) == 1 and False:
        for node_name in cmds.ls(type='mesh'):
            cmds.sets(node_name, e=True, forceElement=shaders_to_apply[0])

    else:
        for sg_name in shaders_to_apply:
            sg_data_raw = cmds.getAttr('%s.%s' % (sg_name, shading_info_attribute))
            sg_data = ast.literal_eval(sg_data_raw)
            for node_name, node_data in sg_data.items():
                if node_name.find('format version') > -1:
                    continue
                print('try', sg_name, '->', node_name)
                if node_name in translator_data:
                    node_name = translator_data[node_name]

                node_names = cmds.ls(node_name, l=True)
                for long_node_name in node_names:
                    print(sg_name, '->', long_node_name)

                    cmds.sets(long_node_name, e=True, forceElement=sg_name)
