import importlib
from pprint import pprint

import maya.cmds as cmds

import library.core.config_manager as config_manager

import actions.maya.post_anim.export_usd_cache as export_usd_cache
import actions.maya.animation.check_atom as check_atom

#importlib.reload(check_atom)
importlib.reload(export_usd_cache)
#importlib.reload(usd_manager)



ASSET_NODES={'Cameras': {'suffix': 'CAM', 'group': 'Camera'},
             'Main Characters': {'suffix': 'CHAR', 'group': 'Characters'},
             'Secondary Characters': {'suffix': 'CHAR', 'group': 'Characters'},
             'Setprops': {'suffix': 'PROP', 'group': 'Props'},
             'Props': {'suffix': 'PROP', 'group': 'Props'},
             'Sets': {'suffix': 'SET', 'group':'Sets'},
        }

def set_maya_project(project_name):
    config_solver = config_manager.ConfigSolver(project=project_name)
    project_data = config_solver.project_config
    print('Fps: %s %s' % (project_data['fps'], project_data['fps_name']))
    cmds.optionVar(sv=['workingUnitTime', project_data['fps_name']])
    cmds.optionVar(sv=['workingUnitTimeDefault', project_data['fps_name']])
    cmds.currentUnit(t=project_data['fps_name'])

def create_animation_scene(project,
                           publish_id,
                           output_path,
                           rig_controls='Rig_Controls',
                           preroll=10,
                           postroll=10):

    import shotgrid_lib.database as database
    importlib.reload(database)
    set_maya_project(project)

    database = database.DataBase()
    database.fill(project, precatch=False)

    database.query_sg_database('Step', as_precache=True)

    filters = [['id', 'is', publish_id]]
    database.query_sg_database('CustomEntity09', filters=filters)
    current_publish = database['CustomEntity09'].find_with_filters(id=publish_id, single_item=True)
    print(current_publish.sg_down_dependencies)
    valid_types = ['Characters', 'Props', 'Setprops']
    shot_view = current_publish.sg_context

    options = ';targetTime=3;option=scaleReplace;match=string;;selected=selectedOnly;'
    set_parents = {}

    print('check breakdown')
    for item in shot_view.sg_breakdowns:
        item_asset = item.sg_asset_name
        print(item_asset)
        item_type = item.sg_asset.sg_asset_type
        sufix = ASSET_NODES.get(item_type, {}).get('suffix', 'NAN')
        item_alias = item.sg_alias
        item_instance = item.sg_instance
        print('Alias', item_alias)
        if item_alias:
            item_name = '%s_%s' % (item_alias, sufix)
        else:
            item_name = '%s_%03d_%s' % (item_asset, item_instance, sufix)

        short_type = item_type.split(' ')[-1]
        print('short_type', short_type)
        if short_type not in valid_types:
            continue
        print('create short type node ', short_type)
        group = ASSET_NODES[item_type]['group']
        if not cmds.objExists(group):
            cmds.createNode('transform', n=group)

        print('created')
        item_variant = item.sg_geometry_variant_name
        print(item_variant)
        item_parent_set = item.sg_parent_asset
        print('item parent ', item_parent_set)

        if item_parent_set and not item_parent_set.empty:
            set_name = item_parent_set.sg_asset_name
            name_in_parent = item.sg_name_in_parent
            set_parents[set_name] = set_parents.get(set_name, {})
            set_parents[set_name][name_in_parent] = item_name.rsplit('_', 1)[0]

        print('to load rig')
        for dependency in current_publish.sg_down_dependencies:
            if dependency.sg_step_name != 'Rig':
                continue

            if dependency.sg_asset_name == item_asset and dependency.sg_variant_name == item_variant:
                full_asset_path = '%s/%s' % (dependency.sg_published_folder, dependency.sg_files.get('rig'))
                print('create rig assembly', item_name)
                node_name = cmds.createNode('RigAssembly', name=item_name, parent=group)
                cmds.setAttr('%s.assetName' % node_name, item_name, type='string')
                cmds.setAttr('%s.assetName' % node_name, lock=1)
                cmds.setAttr('%s.assetType' % node_name, item_type, type='string')
                cmds.setAttr('%s.assetType' % node_name, lock=1)
                cmds.setAttr('%s.instanceNumber' % node_name, item_instance)
                cmds.setAttr('%s.instanceNumber' % node_name, lock=1)

                cmds.setAttr('%s.rigPath' % node_name, full_asset_path, type='string')
                cmds.setAttr('%s.rigPath' % node_name, lock=1)

                #set_maya_project(project)

                file_tab = '%s_%03d_animation' % (item_asset, item_instance)
                animation_path = current_publish.sg_files.get(file_tab)
                if not animation_path:
                    print('cant find animation file for %s' % file_tab)
                    continue
                full_path = '%s/%s' % (current_publish.sg_published_folder, animation_path)
                namespace = cmds.getAttr('%s.representationNamespace' % item_name)

                controls_set = '%s:%s' % (namespace, rig_controls)
                print('Control sets', controls_set)
                if cmds.objExists(controls_set):
                    cmds.select(controls_set, r=True)
                    check_atom.appy_atom_file(full_path, item_name)

    set_paths = {}
    print('check parent assets')
    import usd.lib.usd_manager as usd_manager


    for set_code, set_data in set_parents.items():
        pprint(set_data)
        for prim_path, rig_path in set_data.items():

            asset_children = cmds.listRelatives('%s_PROP' % rig_path, ad=True, f=True)
            set_paths[rig_path] = prim_path.rsplit('/', 1)[0]





    pprint(set_paths)
    shot_name = shot_view.code
    start_frame = shot_view.sg_cut_in - preroll
    end_frame = shot_view.sg_cut_out + postroll

    maya_path = '%s.mb' % output_path.rsplit('.', 1)[0]
    print('export cache')
    pprint(set_paths)
    export_usd_cache.export_usd_cache(project, shot_name, start_frame, end_frame,  output_path, set_paths)
    cmds.file(rename=maya_path)
    maya_type = 'MayaBinary'
    cmds.file(save=True, type=maya_type, force=True)
    print('Saving maya scene to: %s ' % maya_path)



if __name__ == '__main__':
    import argparse

    print('Running export alembic')
    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-s', '-source', '--source-file', dest='source', help='Source file path')
    parser.add_argument('-op', '-output', '--output-path', dest='output_path', help='Output file folder')
    parser.add_argument('-p', '-project', '--project', dest='project', help='Project code')
    parser.add_argument('-i', '-id', '--shotgrid-id', dest='shotgrid_id', help='Current publish shotgrid ID', type=int)

    args = parser.parse_args()

    import maya.standalone as standalone

    standalone.initialize(name='python')

    #cmds.file(args.source, o=True)

    create_animation_scene(args.project,
                           args.shotgrid_id,
                           args.output_path,
                           rig_controls='Rig_Controls',
                           preroll=10,
                           postroll=10)