from pprint import pprint
import maya.cmds as cmds


def move_lights(root_node, light_node):
    print('Root', root_node)
    print('light_node', light_node)
    children = cmds.listRelatives(light_node, c=True)
    print(children)
    if not children:
        return

    for node in children:
        target_node = '%s|%s' % (root_node, node)
        source_node = '%s|%s' % (light_node, node)

        if cmds.objExists(target_node):
            move_lights(target_node, source_node)
        else:
            print('move')
            print('source', source_node)
            print('target', target_node)
            cmds.parent(source_node, root_node)

def import_light_rig(step_data=None, project='', current_step=''):
    volumetric_shaders = ['aiFog', 'aiAtmosphereVolume', 'aiStandardVolume']
    print('import_light_rig')
    print('*' * 100)
    pprint(step_data)
    print('*' * 100)
    namespace = '%s_LRG' % (step_data['code'])
    path = '%s/%s' % (step_data['published_folder'], step_data['files']['rig'])
    cmds.file(path, i=True)
    root_node = 'LightRig'
    asset_lights = '%s_LightRig' % step_data['code']
    if cmds.objExists(asset_lights) and cmds.objExists(root_node):
        move_lights(root_node, asset_lights)
        cmds.delete(asset_lights)

    for volume_type in volumetric_shaders:
        shaders = cmds.ls(type=volume_type)
        if not shaders:
            continue
        for sg in shaders:
            cmds.connectAttr('%s.message' % sg, 'defaultArnoldRenderOptions.atmosphere')