import os
import importlib
import maya.cmds as cmds
from pxr import Usd, UsdGeom, Sdf

import usd.lib.usd_manager as usd_manager

#importlib.reload(usd_manager)


def select_atmosphere():
    render_globals = 'defaultArnoldRenderOptions'
    if not cmds.objExists(render_globals):
        return
    atmosphere = '%s.atmosphere' % render_globals

    connected = cmds.listConnections(atmosphere, p=True)
    selection = []
    if connected:

        for connection in connected:
            node = connection.split('.')[0]
            selection.append(node)

    cmds.select(selection, add=True)


def export_light_rig(target,
                     root,
                     shotgrid_id=None,
                     asset_name='',
                     asset_type='',
                     light_rig_version='',
                     variant='',
                     publish_hash=''):

    attribute_list = ['path',
                      'assetName',
                      'assetType',
                      'fileTag',
                      'pipelineStep',
                      'variant',
                      'version',
                      'shotgrid_id',
                      'hash']

    if not cmds.objExists(root):
        return

    for attribute_name in attribute_list:
        if not cmds.attributeQuery(attribute_name, node=root, exists=True):
            cmds.addAttr(root, ln=attribute_name, dt='string')

    cmds.setAttr('%s.path' % root, target, type='string')

    cmds.setAttr('%s.assetName' % root, asset_name, type='string')
    cmds.setAttr('%s.assetType' % root, asset_type, type='string')

    cmds.setAttr('%s.fileTag' % root, 'rig', type='string')
    cmds.setAttr('%s.pipelineStep' % root, 'lighset', type='string')
    cmds.setAttr('%s.variant' % root, variant, type='string')
    cmds.setAttr('%s.version' % root, str(light_rig_version), type='string')
    cmds.setAttr('%s.shotgrid_id' % root, 'customEntity09:%s' % shotgrid_id, type='string')
    cmds.setAttr('%s.hash' % root, publish_hash, type='string')



    extension = target.split('.')[-1]

    if extension == 'mb':
        export_type = 'mayaBinary'
    else:
        export_type = 'mayaAscii'

    cmds.select(root, r=True)
    select_atmosphere()
    cmds.file(target, exportSelected=True, force=True, type=export_type)

def add_attribute(prim, attribute, value=None, attr_type=Sdf.ValueTypeNames.String):
    new_attr = prim.CreateAttribute(attribute, attr_type)
    if value is not None:
        new_attr.Set(value)
    return new_attr

def export_usd_light_rig(target,
                         root,
                         shotgrid_id=None,
                         asset_name='',
                         asset_type='',
                         version='',
                         variant='',
                         publish_hash='',
                         project=''):
    cmds.select(root, r=True)
    dirname = os.path.dirname(target)
    if not os.path.exists(dirname):
        os.makedirs(dirname)

    options = '-boundingBox;-asciiAss;-mask 28;-lightLinks 1;-shadowLinks 2;-fullPath;' #-exportPrefix"/world/lights/"'
    print(target)
    print('Asset name', asset_name)
    print('Asset type', asset_type)
    export_type = 'Arnold-USD'

    cmds.file(target, exportSelected=True, force=True, type=export_type, pr=True, options=options, )
    #cmds.arnoldExportAss(f=target, mask=6396, s=True, exportAllShadingGroups=True, asciiAss=True)

    manager = usd_manager.UsdManager(project)
    manager.set_entity(asset_name, 'Asset', asset_type=asset_type)
    manager.open(target)
    asset_prim = manager.stage.DefinePrim('/asset', 'Xform')
    setings_prim = manager.stage.DefinePrim('/asset/renderSetting')

    pseudo_root = manager.stage.GetPrimAtPath('/')
    print(pseudo_root)
    for child in pseudo_root.GetChildren():

        child_path = child.GetPath()
        print(child_path)
        if child_path in ['/mtl', '/light_rig']:

            new_path = '/asset%s' % str(child_path)
            print('child path:', child_path)
            print('new path:', new_path)

            manager.repath_prim(child_path, new_path)
        else:
            new_path = '/asset/renderSetting%s' % str(child_path)
            print(child, new_path)
            manager.repath_prim(child_path, new_path)

    manager.default_prim = '/asset'

    base_prim = manager.stage.GetPrimAtPath('/asset/light_rig/base')
    if base_prim.IsValid():
        manager.set_prim_purpose('/asset/light_rig/base', 'render')

    chart_prim = manager.stage.GetPrimAtPath('/asset/light_rig/chart')
    if chart_prim.IsValid():
        manager.set_prim_purpose('/asset/light_rig/chart', 'render')

    manager.asset_info = {'asset_name': asset_name,
                          'asset_type': asset_type,
                          'lightrig_variant': variant,
                          'lightrig_version': version,
                          'lighttig_shotgrid_id': shotgrid_id,
                          'lightrig_publish_path': target
                          }

    manager.save_stage()

    return {'usd': target}


def export_usd_shot_light(target,
                         root,
                         shotgrid_id=None,
                         shot_name='',
                         version='',
                         variant='',
                         publish_hash='',
                         project=''):
    cmds.select(root, r=True)
    dirname = os.path.dirname(target)
    if not os.path.exists(dirname):
        os.makedirs(dirname)

    options = '-boundingBox;-asciiAss;-mask 28;-lightLinks 1;-shadowLinks 2;-fullPath'  # -exportPrefix"/world/lights/"'
    print('output_path', target)
    print('Shot name', shot_name)

    cmds.arnoldExportAss(f=target, mask=28, s=True, exportAllShadingGroups=True, asciiAss=True, exportPrefix='World/')

    manager = usd_manager.UsdManager(project)
    manager.set_entity(shot_name, 'Shot')
    manager.open(target)
    world_prim = manager.stage.DefinePrim('/World', 'Xform')
    manager.default_prim = '/World'
    print(world_prim, world_prim.IsValid())
    #light_prim = manager.stage.DefinePrim('/World/lighting', 'Xform')
    #print(light_prim, light_prim.IsValid())


    pseudo_root = manager.stage.GetPrimAtPath('/')
    print(pseudo_root)
    for child in pseudo_root.GetChildren():
        child_path = child.GetPath()
        if child_path not in ['/mtl', '/light_rig', '/World']:
            child_name = child.GetName()
            new_path = '/World/lighting/%s' % child_name

            manager.repath_prim(child_path, new_path)

    new_path = '/World/lighting'

    manager.repath_prim('/LightRig', new_path)

    set_ligth_paths = get_set_paths(shot_name, project)
    for set_light in set_ligth_paths:
        print('create', set_light)
        sets_prim = manager.stage.DefinePrim(set_light)
        sets_prim.SetActive(False)

    manager.save_stage()

def get_set_paths(shot_name, project):
    set_paths = []
    manager = usd_manager.UsdManager(project)
    manager.set_entity(shot_name, 'Shot')
    manager.open(manager.filename)
    sets_prim = manager.stage.GetPrimAtPath('/World/Sets')
    if not sets_prim.IsValid():
        return []

    for child in sets_prim.GetChildren():
        child_path = child.GetPath()
        render_path = child_path.AppendChild('renderSetting')

        render_prim = manager.stage.GetPrimAtPath(render_path)
        print( render_path)

        if render_prim.IsValid():
            print('>>', render_path)

            set_paths.append(render_path)

    return set_paths