import os
from pprint import pprint
import importlib

import maya.cmds as cmds

import actions.maya.set_dressing.compare_set as compare_sets
import usd.lib.usd_manager as usd_manager

importlib.reload(compare_sets)
importlib.reload(usd_manager)


def check_set(prim, root_folder, project, usd_shape, sets_root, manager):
    default_prim = manager.default_prim
    print(root_folder)

    print('this prim', prim)
    asset_name = manager.get_attribute(prim, 'atlantis:asset_name')

    asset_path = '%s/set_edit_%s.usda' % (root_folder, asset_name)
    print(asset_path)

    sets_root = prim.GetPath().pathString
    compare_sets.compare_set(usd_shape, asset_name, asset_path, project, sets_roots=sets_root)
    path_bits = asset_path.split('/')

    return asset_path # '%s/%s' % (path_bits[-2], path_bits[-1]),


def export_set_edit( output_path='', project='', shot_name=''):
    output_path = output_path.replace('\\', '/')
    set_manager = usd_manager.UsdManager(project)
    set_manager.set_entity(shot_name, 'Shot')
    set_manager.open(output_path)

    usd_shape_nodes = cmds.ls(type='mayaUsdProxyShape', l=True)
    output_files = {}
    all_layers = []
    root_folder = os.path.dirname(output_path)

    for usd_shape in usd_shape_nodes:
        manager = usd_manager.UsdManager(project)
        manager.get_stage_from_maya(usd_shape)
        stage = manager.stage

        default_prim = manager.default_prim
        if default_prim.GetPath().pathString == '/World':

            sets_root = '/World/Sets'
            set_prim = stage.GetPrimAtPath(sets_root)

            for child in set_prim.GetChildren():
                layer_path = check_set(child, root_folder, project, usd_shape, sets_root, manager)
                all_layers.append(layer_path)

        elif default_prim.GetPath().pathString == '/asset':
            sets_root = '/asset'
            layer_path = check_set(default_prim, root_folder, project, usd_shape, '', manager)
            all_layers.append(layer_path)



    for index, layer in enumerate(all_layers):
        set_manager.add_sublayer(layer)

    set_manager.save_stage()
    path_bits = output_path.split('/')
    output = {'output_files': {'set_edit': '%s/%s' % (path_bits[-2], path_bits[-1])}}

    return output
