import importlib
import maya.cmds as cmds

connections_data = {'source': {'translate': 'target[0].targetTranslate',
                               'rotatePivot': 'target[0].targetRotatePivot',
                               'rotatePivotTranslate': 'target[0].targetRotateTranslate',
                               'rotate': 'target[0].targetRotate',
                               'rotateOrder': 'target[0].targetRotateOrder',
                               'scale': 'target[0].targetScale',
                               'parentMatrix': 'target[0].targetParentMatrix',
                               },
                    'target': {'constraintTranslateX': 'translateX',
                               'constraintTranslateY': 'translateY',
                               'constraintTranslateZ': 'translateZ',
                               'constraintRotateX': 'rotateX',
                               'constraintRotateY': 'rotateY',
                               'constraintRotateZ': 'rotateZ',
                               },
                    'contraint': {'rotateOrder': 'constraintRotateOrder',
                                  'parentInverseMatrix': 'constraintParentInverseMatrix',
                                  'rotatePivot': 'constraintRotatePivot',
                                  'rotatePivotTranslate': 'constraintRotateTranslate',
                                  }
                    }


def create_parent_constraint():
    selected_nodes = cmds.ls(sl=True)
    print(selected_nodes)
    if len(selected_nodes) < 2:
        print('you must select at least two nodes')
        return
    source_nodes = selected_nodes[:-1]
    target_node = selected_nodes[-1]

    constraint = cmds.createNode('parentConstraint')

    for index, source_node in enumerate(source_nodes):
        print(source_node)
        for source_attr, target_attr in connections_data['source'].items():
            print(target_attr)
            target_attr = target_attr.replace('0', str(index))
            print(target_attr)
            cmds.connectAttr('%s.%s' % (source_node, source_attr), '%s.%s' % (constraint, target_attr), f=True)

    for source_attr, target_attr in connections_data['target'].items():
        cmds.connectAttr('%s.%s' % (constraint, source_attr), '%s.%s' % (target_node, target_attr), f=True)

    for target_attr, source_attr in connections_data['contraint'].items():
        cmds.connectAttr('%s.%s' % (target_node, target_attr), '%s.%s' % (constraint, source_attr), f=True)


