import importlib
import shotgrid_lib.database as database

import publisher.lib.publish_cmd as publisher_cmd
importlib.reload(publisher_cmd)

from pprint import pprint




def launch_postanim(shotgrid_id, project='SGD'):

    if isinstance(shotgrid_id, str):
        publish_id = shotgrid_id.split(':')[-1]
        if publish_id.isdigit():
            publish_id = int(publish_id)

    elif isinstance(shotgrid_id, int):
        publish_id = shotgrid_id

    else:
        return

    sg_database = database.DataBase()
    sg_database.fill(project=project, precatch=False)

    filters = [['id', 'is', publish_id]]

    sg_database.query_sg_database('CustomEntity09', filters=filters)
    sg_database.query_sg_database('Step')

    published_version = sg_database['CustomEntity09'].find_with_filters(id=publish_id, single_item=True)
    published_version.precache_dependencies(fields=['sg_context', 'sg_task'])
    print(published_version)
    metadata = published_version.sg_metadata
    if not metadata or metadata == 'None':
        metadata = {}

    assemblies = []
    for key, instance_data in metadata.get('assets', {}).items():
        for instance_number, assembly_node in instance_data.items():
            assemblies.append(assembly_node)

    scene_path = '%s/%s' % (published_version.sg_published_folder, published_version.sg_files.get('scene'))

    assemblies_str = ','.join(assemblies)
    print(assemblies_str)
    shot_publish = published_version.sg_context
    shot_publish.precache_dependencies()
    step_view = sg_database['Step']['PostAnim']
    task_view = shot_publish.tasks.find_with_filters(step=step_view, single_item=True)

    publish_path = '%s/%s' % (published_version.sg_published_folder, published_version.sg_files.get('scene', ''))
    parameters = {'assemblies': assemblies_str,
                  'entity_name': shot_publish.code,
                  'comment': 'launched from animation: %s version %s' % (published_version.code, published_version.sg_version_number),
                  'animation_id': shotgrid_id,
                  'start_frame': shot_publish.sg_cut_in,
                  'end_frame': shot_publish.sg_cut_out,
                  'task_code': task_view.content,
                  'source_path': scene_path,
                  'project': project,
                  'dependencies': {shot_publish.code: {published_version.code: {'Animation': {'id': shotgrid_id,
                                                                                              'type': 'CustomEntity09',
                                                                                              'code': published_version.code
                                                                                              }
                                                                                }
                                                       }
                                   }
                  }
    pprint(parameters)
    publisher_cmd.PublishCmd('Postanim', parameters, project)



if __name__ == '__main__':
    import argparse
    print('running post anim')
    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-id', '-id', '--shotgrid-id', dest='shotgrid_id', help='Temp files output path', default='1077')
    parser.add_argument('-p', '-project', '--project', dest='project', default='TPT', help='The code of the project')
    args = parser.parse_args()
    shotgrid_id = int(args.shotgrid_id)
    launch_postanim(shotgrid_id, project=args.project)