import maya.cmds as cmds

def get_atom_namespace(path, scene_namespace):

    atom_file = open(path, 'r')

    for line in atom_file.readlines():
        if line.find(':') > -1:
            bits = line.split(' ')
            for bit in bits:
                if bit.find(':') > -1:
                    new_namespace, node_name = bit.split(':', 1)
                    scene_node = '%s:%s' % (scene_namespace, node_name)
                    if cmds.objExists(scene_node):
                        atom_file.close()
                        return new_namespace

    return None

def import_atom_file(atom_path, atom_namespace, scene_namespace):

    opti0ns_dict = {'targetTime': 3,
                   'option':'scaleReplace',
                   'match': 'string',
                   'selected': 'selectedOnly',
                   'search': atom_namespace,
                   'replace': scene_namespace,
                   }

    options = []
    for key, value in opti0ns_dict.items():
        options.append('%s=%s' % (key, value))

    options_string = ';'.join(options)
    cmds.file(atom_path, i=True, type='atomImport', ra=True, options=options_string)

def get_scene_namespace():

    selected_nodes = cmds.ls(sl=True)
    for node in selected_nodes:
        if node.find(':') == -1:
            continue
        namespace = node.split(':')[0]
        return namespace

def appy_atom_file(atom_path, rig_node):

    cmds.select('%s_NS:Rig_Controls' % rig_node, r=True)
    selected_nodes = cmds.ls(sl=True)
    scene_namespace = get_scene_namespace()
    atom_namespace = get_atom_namespace(atom_path, scene_namespace)
    print(scene_namespace, atom_namespace)

    import_atom_file(atom_path, atom_namespace, scene_namespace)


if __name__ == '__main__':
    path = 'C:/Users/larry/Documents/maya/projects/default/data/test_atom.atom'
    path = 'V:/TPT/publish/animation/s00/s00_ep01/s00_ep01_sq010/s00_ep01_sq010_sh010/s00_ep01_sq010_sh010_Master_375acb566aeab4a6/v041/animation/Joystick_001.atom'

    scene_namespace = 'Joystick_001_PROP'

    appy_atom_file(path)


