import time

import substance_painter.project as sp_project
import substance_painter.resource as sp_resource


def create_substance_project(step_data=None, project='', current_step='', filename=''):
    print('create substance project')
    print('filename', filename)
    template_path = 'C:/Program Files/Adobe/Adobe Substance 3D Painter/resources/starter_assets/templates/PBR - Metallic Roughness Alpha-blend.spt'
    animation_path = step_data['files'].get('usd')
    import_settings = sp_project.Settings(normal_map_format=sp_project.NormalMapFormat.OpenGL,
                                          project_workflow=sp_project.ProjectWorkflow.UVTile
                                          )

    mesh_path = '%s/%s' % (step_data['published_folder'], animation_path)
    sp_project.create(mesh_file_path=mesh_path, template_file_path=template_path, settings=import_settings)

    sp_project.execute_when_not_busy(sp_project.save_as(filename))
