import os
import sys
sys.path.insert(0, 'C:/dev')
import datetime

import importlib
import photoshop_tools.psd_tools as psd_tools

importlib.reload(psd_tools)

os.environ['OPENCV_IO_ENABLE_OPENEXR']='True'

import cv2
import numpy as np

from PIL import Image, ImageDraw, ImageFont, ImageSequence

print(psd_tools)



# Uso del script
base_color = (254, 252, 240)
text_color = (200, 200, 255)


def save_psd_to_png(pdf_path, png_path):
    im = Image.open(pdf_path)
    print(im.layers)
    layers = [frame.copy() for frame in ImageSequence.Iterator(im)]
    for frame in ImageSequence.Iterator(im):
        print(frame.copy())

    im.save(png_path, 'PNG')

def psd_to_png(psd_path):
    png_path = psd_path.replace('.psd', '.png')

    # Abrir el archivo PSD
    psd = psd_tools.PSDImage.open(psd_path)
    # Buscar y ocultar la capa de fondo si existe
    psd[0].visible = False

    # Componer la imagen en formato RGBA
    composite_image = psd.compose(force=True)

    # Guardar la imagen como PNG
    composite_image.save(png_path, 'PNG')
    return png_path

def exr_to_png(exr_file_path):

    png_path = exr_file_path.replace('.exr', '.png')
    im = cv2.imread(exr_file_path, -1)
    im = im * 65535
    im[im > 65535] = 65535
    im = np.uint16(im)
    cv2.imwrite(png_path, im)

    return png_path

def draw_margin(draw, image_width, image_heigh, margin=10, width=3):
    x_min =  margin
    y_min =  margin

    x_max = image_width - margin
    y_max = image_heigh - margin

    draw.line((x_min, y_min, x_max, y_min), fill=base_color, width=width)
    draw.line((x_min, y_max, x_max, y_max), fill=base_color, width=width)
    draw.line((x_max, y_min, x_max, y_max), fill=base_color, width=width)
    draw.line((x_min, y_min, x_min, y_max), fill=base_color, width=width)


def draw_box(draw, image_width, image_heigh, ratio=.15, margin=20, width=2, top=True, left=False):

    min_side = min ([image_width, image_heigh])
    if left:
        x_min = margin
        x_max = image_width * ratio - margin
    else:
        x_min = image_width - image_width * ratio + margin
        x_max = image_width - margin

    if top:
        y_min = margin
        y_max = image_heigh * ratio - margin

    else:
        y_min = image_heigh - image_heigh * ratio + margin
        y_max = image_heigh - margin


    height_steps = (y_max - y_min) / 5

    for index in range(4):
        new_y = y_min + height_steps * (index + 1)
        draw.line((x_min, new_y, x_max, new_y), fill=base_color, width=2)

    draw.line((x_min, y_min, x_max, y_min), fill=base_color, width=3)
    draw.line((x_min, y_max, x_max, y_max), fill=base_color, width=3)
    draw.line((x_max, y_min, x_max, y_max), fill=base_color, width=3)
    draw.line((x_min, y_min, x_min, y_max), fill=base_color, width=3)

    return x_min, y_min, x_max, y_max

def burnin_image(path,
                 output_path,
                 asset_name,
                 artist_name,
                 department='Preprod',
                 step='Design',
                 version=0,
                 background_color=(100,100,100)):
    background_path = 'C:/dev/actions/resources/background_format.png'

    if isinstance(version, int):
        version = '%03d' % version
    extension = path.split('.')[-1]
    if extension == 'exr':
        png_path = exr_to_png(path)
        im = Image.open(png_path)
    elif extension == 'psd':
        png_path = psd_to_png(path)
        im = Image.open(png_path)

    else:
        im = Image.open(path)

    width = im.size[0]
    height = im.size[1]
    draw = ImageDraw.Draw(im)

    x_min, y_min, x_max, y_max = draw_box(draw, width, height)
    draw_margin(draw, width, height)

    #draw.line((100,200, 150,300), fill=128)

    height_steps = (y_max - y_min) / 5
    fontsize = int(height_steps /2)
    print(fontsize)
    font = ImageFont.truetype("arial.ttf", fontsize)

    text_position_x = x_min + 10
    text_position_y = y_min + 5

    draw.text((text_position_x, text_position_y), 'Asset: %s ' % asset_name, font=font,fill=text_color)

    text_position_y = y_min + 5 + height_steps * 1
    draw.text((x_max-200, text_position_y), 'Version: v%s ' % version, font=font, fill=text_color)
    draw.text((text_position_x, text_position_y), 'Step: %s ' % step, font=font, fill=text_color)

    text_position_y = y_min + 5 + height_steps * 2

    draw.text((text_position_x, text_position_y), 'Artist: %s ' % artist_name, font=font, fill=text_color)

    text_position_y = y_min + 5 + height_steps * 3
    draw.text((text_position_x, text_position_y), 'Department: %s ' % department, font=font, fill=text_color)

    text_position_y = y_min + 5 + height_steps * 4

    today = datetime.datetime.today()
    draw.text((text_position_x, text_position_y), 'Date: %s ' % today, font=font, fill=text_color)

    new_image = Image.open(background_path)
    new_image.paste(im, (0, 0), im)  # Paste the image on the background. Go to the links given below for details.


    dirname = os.path.dirname(output_path)
    print(dirname)
    if not os.path.exists(dirname):
        os.makedirs(dirname)

    new_image.convert('RGB').save(output_path, "JPEG")

    #new_image.show()


if __name__ == '__main__':
    #path = 'V:/TPT/publish/design/Main_Characters/LeoHero/LeoHero_poseComparison_aeb1d33e9ef36bf3/v001/concept/LeoHero.png'
    #path = 'V:/TPT/publish/postanim/s00/s00_ep01/s00_ep01_sq020/s00_ep01_sq020_sh010/s00_ep01_sq020_sh010_Master_80de7776839bf18c/v044/render/beauty/s00_ep01_sq020_sh010.1003.exr'
    path = 'V:/TPT/publish/shading/Main_Characters/LeoHero/Master/LeoHero_Master_3c8bd55b4ce5c138/v028/turntable/beauty/LeoHero.0109.exr'

    path = 'C:/projects/nona_image.psd'
    output_path = 'C:/projects/nona_image_format.png'
    name= 'Fernando.Vizoso'
    asset_name = 'LeoHero'
    burnin_image(path, output_path, asset_name, name)