import logging
import time

import maya.cmds as cmds

logger = logging.getLogger(__name__)
def check_sets():

    rig_set = 'Rig_Sets'
    control_set = 'Rig_Controls'
    geo_set = 'Rig_Geo'
    locator_set = 'Rig_Locators'
    success = True

    errors = []
    if not cmds.objExists(rig_set):
        logger.error('The main Rig set don\'t exists')
        success = False

    if not cmds.objExists(control_set):
        logger.error('The control set don\'t exists')
        success = False

    else:
        control_elements = cmds.sets(control_set, q=True, s=True)
        if control_elements == 0:
            logger.error('The control set is empty')
            success = False

    if not cmds.objExists(locator_set):
        logger.error('The Locator set don\'t exists')
        success = False

    if not cmds.objExists(geo_set):
        logger.error('The geo set don\'t exists')
        success = False
    else:
        geo_elements = cmds.sets(geo_set, q=True, s=True)
        if geo_elements == 0:
            logger.error('The geometry set is empty')
            success = False


    return success

