import logging
import importlib
import usd.lib.usd_manager as usd_manager
importlib.reload(usd_manager)

logger = logging.getLogger(__name__)

def export_model(render_geo,
                 proxy_geo,
                 asset_name,
                 asset_type,
                 output_path,
                 model_variant,
                 model_version,
                 model_shotgrid_id,
                 project,
                 animated=False,
                 start_frame=1,
                 end_frame=24
                 ):


    import maya.cmds as cmds

    if animated:
        animated = 1
    else:
        animated = 0

    #render_geo = cmds.ls(render_geo, long=True)
    render_geo = cmds.listRelatives(render_geo, f=True, c=True)

    if not render_geo:
        logger.error('can\'t find the render geometry: %s' % render_geo)
        return -1
    render_geo = render_geo[0]
    ori_render_path = render_geo.replace('|','/')

    cmds.select(render_geo, r=True)
    #proxy_geo = cmds.ls(proxy_geo, long=True)
    if proxy_geo:
        proxy_geo = cmds.listRelatives(proxy_geo, f=True, c=True)
    if not proxy_geo:
        logger.warning('There is not proxy geometry')
    else:
        proxy_geo = proxy_geo[0]
        cmds.select(proxy_geo, add=True)
        ori_proxy_path = proxy_geo.replace('|', '/')

    options = ';exportUVs=1;exportSkels=none;exportSkin=none;exportBlendShapes=0;exportDisplayColor=0;;exportColorSets=1;exportComponentTags=1;defaultMeshScheme=catmullClark;animation=%s;eulerFilter=0;staticSingleSample=0;startTime=%s;endTime=%s;frameStride=1;frameSample=0.0;defaultUSDFormat=usda;parentScope=;shadingMode=useRegistry;convertMaterialsTo=[];exportRelativeTextures=automatic;exportInstances=1;exportVisibility=1;mergeTransformAndShape=1;stripNamespaces=1;worldspace=0'
    options = options % (animated, start_frame, end_frame)

    cmds.file(output_path, options=options, typ='USD Export', es=True, pr=True)
    print(output_path)
    manager = usd_manager.UsdManager(project)
    manager.set_entity(asset_name, 'Asset', asset_type=asset_type)
    manager.open(output_path)

    manager.maya_set()

    manager.asset_info = {'asset_name': asset_name,
                          'asset_type': asset_type,
                          'model_variant': model_variant,
                          'model_version': model_version,
                          'model_shotgrid_id': model_shotgrid_id,
                          'model_publish_path': output_path
                          }

    render_prim_path = '/asset/render/%s' % render_geo.split('|')[-1]

    logger.info('render prim path: %s' % render_prim_path)

    manager.stage.DefinePrim('/asset', 'Xform')
    manager.default_prim = '/asset'
    manager.set_prim_kind('/asset', 'component')

    manager.stage.DefinePrim('/asset/render', 'Xform')

    manager.repath_prim(ori_render_path, render_prim_path)

    render_prim = manager.stage.GetPrimAtPath(render_prim_path)





    prim_list = [render_prim]
    manager.set_prim_purpose('/asset/render', 'default')
    
    if proxy_geo:
        manager.set_prim_purpose('/asset/render', 'render')
        proxy_prim_path = '/asset/proxy/%s' % proxy_geo.split('|')[-1]
        logger.info('proxy prim path: %s' % proxy_prim_path)

        manager.stage.DefinePrim('/asset/proxy', 'Xform')
        manager.set_prim_purpose('/asset/proxy', 'proxy')
        print(ori_proxy_path)
        print(proxy_prim_path)

        manager.repath_prim(ori_proxy_path, proxy_prim_path)
        proxy_prim = manager.stage.GetPrimAtPath(proxy_prim_path)

        prim_list.append(proxy_prim)


    pseudo_root = manager.stage.GetPseudoRoot()

    for child in pseudo_root.GetChildren():
        path = child.GetPath()
        if str(path) != '/asset':
            manager.delete_prim(child)


    for prim in manager.stage.Traverse():
        if prim.GetTypeName() != 'Mesh':
            continue
        manager.create_attribute(prim, 'primvars:arnold:subdiv_iterations', attribute_type='uchar', value=1)


    manager.save_stage()


    for prim in prim_list:
        manager.create_attribute(prim, 'atlantis:asset_name', value=asset_name)
        manager.create_attribute(prim, 'atlantis:asset_type', value=asset_type)
        manager.create_attribute(prim, 'atlantis:model_variant', value=model_variant)
        manager.create_attribute(prim, 'atlantis:model_version', value=model_version, attribute_type=int)
        manager.create_attribute(prim, 'atlantis:model_shotgrid_id', value=model_shotgrid_id, attribute_type=int)
        manager.create_attribute(prim, 'atlantis:path', value=output_path, attribute_type='path')

    manager.save_stage()


    return {'usd': output_path}




if __name__ == '__main__' and False:
    import argparse

    print('Running export usd')
    parser = argparse.ArgumentParser(description='Shotgun event launcher')
    parser.add_argument('-o', '-output', '--output-file', dest='output', help='Output file path')
    parser.add_argument('-g', '-geo-path', '--geo-path', dest='geo_path', help='render geometry')
    parser.add_argument('-p', '-proxy-path', '--proxy-path', dest='proxy_path', help='proxy geometry')

    args = parser.parse_args()

    create_usd_model(output_path=args.output, geo_path=args.geo_path, proxy_path=args.proxy_path)

if __name__ == '__main__' :

    output_path = r'V:\SGD\publish\model\armChairGamer\Master\armChairGamer_Master_0f4830702a4860c9\v044\usd/armChairGamer_geometry.usda'
    geo_path = r'V:\SGD\publish\model\armChairGamer\Master\armChairGamer_Master_0f4830702a4860c9\v044\abc/armChairGamer_high.abc'
    proxy_path = r'V:\SGD\publish\model\armChairGamer\Master\armChairGamer_Master_0f4830702a4860c9\v044\abc/armChairGamer_low.abc'
    create_usd_model(output_path=output_path,
                         geo_path=geo_path,
                         proxy_path=proxy_path,
                         asset_name='armChairGamer',
                         variant='Master',
                         version=44)
