import os
import importlib

from pprint import pprint

from pxr import Usd, UsdGeom


import usd.lib.usd_manager as usd_manager
import usd.lib.render_layer as render_layer
import library.core.config_manager as config_manager

importlib.reload(render_layer)
importlib.reload(usd_manager)
importlib.reload(usd_manager)



class RenderFileBuilder():
    def __init__(self,
                 project,
                 shot_name,
                 override_layers,
                 output_file_path,
                 render_type,
                 start_frame,
                 end_frame,
                 renderpass='Preview'
                 ):

        self.project = project
        self.shot_name = shot_name
        self.override_layers = override_layers
        self.output_file_path = output_file_path
        self.render_type = render_type
        self.renderpass = renderpass
        self.start_frame = start_frame
        self.end_frame = end_frame

        self.output_images_folder = os.path.dirname(self.output_file_path)
        if not os.path.exists(self.output_images_folder):
            os.makedirs(self.output_images_folder)

        self.shot_assembly_manager = usd_manager.UsdManager(project)
        self.shot_assembly_manager.set_entity(self.shot_name, 'Shot')

        self.add_layers(self.shot_assembly_manager.asset_layers_config)



    def create_render_settings(self, layers_paths):
        import render_config.lib.render_settings as render_settings
        importlib.reload(render_settings)

        images_path = '%s/<aov>/%s.<frame>.exr' % (self.output_images_folder, self.shot_name)

        config_builder = render_settings.RenderConfig(self.project,
                                                      self.shot_name,
                                                      'Shot',
                                                      self.render_type,
                                                      self.output_file_path,
                                                      images_path,
                                                      self.start_frame,
                                                      self.end_frame,
                                                      renderpass=self.renderpass,
                                                      layer_paths=layers_paths
                                                      )

        return config_builder.manager


    def add_layers(self, layers_config):

        layer_paths = []

        for layer_config in layers_config:
            for layer_name, layer_data in layer_config.items():
                if layer_name in self.override_layers:
                    filepath = self.override_layers[layer_name]
                else:
                    filepath = self.shot_assembly_manager.get_layer_filename(layer_name)
                print('>>>', filepath)
                layer_paths.append(filepath)

        manager = self.create_render_settings(layer_paths)

        manager.save_stage()

def build_render(project,
                 shot_name,
                 lights_path,
                 output_path,
                 render_type='preview_render',
                 start_frame=1001,
                 end_frame=1011,
                 renderpass='Preview'):
    override_layers = {}
    if lights_path:
        override_layers['Light'] = lights_path


    builder = RenderFileBuilder(project,
                                shot_name,
                                override_layers,
                                output_path,
                                render_type,
                                start_frame,
                                end_frame,
                                renderpass=renderpass)
def test_build_render():
    project = 'TPT'
    shot_name = 's00_ep01_sq030_sh060'

    light_file_path = 'V:/TPT/publish/lighting/s00/s00_ep01/s00_ep01_sq020/s00_ep01_sq020_sh010/s00_ep01_sq020_sh010_Master_65938c9dfb3da43f/v013/usd/s00_ep01_sq020_sh010.usd'
    override_layers = {'Light':  light_file_path}
    override_layers = {}
    output_file_path = 'C:/Users/fernando.vizoso/Documents/maya/projects/default/data/render.usda'
    if os.path.exists(output_file_path):
        os.remove(output_file_path)
    render_type = 'rendering'
    builder = RenderFileBuilder(project,
                                shot_name,
                                override_layers,
                                output_file_path,
                                render_type,
                                1001,
                                1060,
                                renderpass='Background')

if __name__ == '__main__':
    test_build_render()