import logging

import maya.cmds as cmds


logger = logging.getLogger(__name__)

def check_assembly_data():
    success = True
    all_rig_assemblies = cmds.ls(type='RigAssembly')
    for rig_node in all_rig_assemblies:
        asset_name = cmds.getAttr('%s.assetName' % rig_node)
        asset_type = cmds.getAttr('%s.assetType' % rig_node)
        instance_number = cmds.getAttr('%s.instanceNumber' % rig_node)
        if not asset_name:
            success = False
            logger.error('The node %s dont have the attribute assetName correctly set' % rig_node)

        if not asset_type:
            success = False
            logger.error('The node %s dont have the attribute assetType correctly set' % rig_node)

        if not instance_number:
            success = False
            logger.error('The node %s dont have the attribute instanceNumber correctly set' % rig_node)


    return success


