from pprint import pprint

import maya.cmds as cmds

def load_camera_cache(step_data=None, project='', current_step=''):
    print('load camera cache')
    asset_folder = step_data['published_folder']

    usd_file = step_data['files'].get('usd')
    pprint(step_data['files'])
    print(usd_file)
    full_path = '%s/%s' % (asset_folder, usd_file)
    print('LOAD MODEL', full_path)

    parent_name = 'Shot_elements'
    if not cmds.objExists(parent_name):
        cmds.createNode('transform', name=parent_name)
    cmds.mayaUSDImport(file=full_path, primPath='/World/Camera', ani=True, parent=parent_name)

    cmds.addAttr('|Shot_elements|Camera', longName='asset_name', dataType='string')
    cmds.setAttr('|Shot_elements|Camera.asset_name', 'Camera', type='string')

    cmds.addAttr('|Shot_elements|Camera', longName='asset_type', dataType='string')
    cmds.setAttr('|Shot_elements|Camera.asset_type', 'Others', type='string')

    cmds.addAttr('|Shot_elements|Camera', longName='model_version', dataType='string')
    cmds.setAttr('|Shot_elements|Camera.model_version', step_data['version_number'], type='string')

    for node in cmds.listRelatives('|Shot_elements|Camera', ad=True, f=True):
        if not cmds.nodeType(node) == 'transform':
            cmds.lockNode(node, lock=True)

            continue
        cmds.setAttr('%s.translate' % node, lock=True, e=True)
        cmds.setAttr('%s.rotate' % node, lock=True, e=True)
        cmds.setAttr('%s.scale' % node, lock=True, e=True)
        cmds.lockNode(node, lock=True)

