
from pprint import pprint

import maya.cmds as cmds

import usd.lib.usd_manager as usd_manager


def open_usd_setdressing(step_data=None, project='', current_step=''):
    asset_name = step_data['code']
    shape_node = cmds.createNode('mayaUsdProxyShape', name='%sShape' % asset_name)
    parent_node = cmds.listRelatives(shape_node, p=True)
    cmds.rename(parent_node, asset_name)
    set_usd_path = 'V:/%s/publish/usd/assets/Sets/%s/setDressing/%s_setDressing.usda' % (project, asset_name, asset_name)
    cmds.setAttr('%s.filePath' % shape_node, set_usd_path, type='string')

def import_usd_set(step_data=None, project='', current_step=''):

    asset_name = step_data['code']
    shape_node = cmds.createNode('mayaUsdProxyShape', name='%sShape' % asset_name)
    parent_node = cmds.listRelatives(shape_node, p=True)
    cmds.rename(parent_node, asset_name)
    set_usd_path = 'V:/%s/publish/usd/assets/Sets/%s/set/%s_set.usda' % (project, asset_name, asset_name)

    cmds.setAttr('%s.filePath' % shape_node, set_usd_path, type='string')

    if 'children' in step_data and isinstance(step_data['children'], list):
        manager = usd_manager.UsdManager(project)
        manager.set_entity(asset_name, 'Asset', asset_type='Sets')
        manager.get_stage_from_maya(shape_node)
        stage = manager.stage

        for prim in stage.Traverse():
            if prim.GetName() in step_data['children']:
                prim.SetActive(False)



def import_usd_set_old(step_data=None, project='', current_step=''):
    asset_name = step_data['code']
    if not cmds.objExists('ShotUSDShape'):
        shape_node = cmds.createNode('mayaUsdProxyShape', name='ShotUSDShape')
        parent_node = cmds.listRelatives(shape_node, p=True)
        cmds.expression(o=shape_node, s='%s.time = frame' % shape_node)

        cmds.rename(parent_node, 'ShotUSD')
    else:
        shape_node = 'ShotUSDShape'

    manager = usd_manager.UsdManager(project)
    manager.set_entity(asset_name, 'Asset', asset_type='Sets')
    manager.get_stage_from_maya(shape_node)
    stage = manager.stage
    world_prim = stage.GetPrimAtPath('/World')
    if not world_prim.IsValid():
        world_prim = stage.DefinePrim('/World', 'Xform')

    set_prim = stage.GetPrimAtPath('/World/Sets')
    if not set_prim.IsValid():
        set_prim = stage.DefinePrim('/World/Sets', 'Xform')
    set_usd_path = '%s/%s' % (step_data['published_folder'], step_data['files'].get('usd'))

    set_usd_path = 'V:/%s/publish/usd/assets/Sets/%s/asset_assembly.usda' % (project, asset_name)
    asset_prim = stage.DefinePrim('/World/Sets/%s' % asset_name, 'Xform')

    payloads = asset_prim.GetPayloads()
    payloads.AddPayload(set_usd_path)

    if 'children' in step_data and isinstance(step_data['children'], list):
        full_names = []
        short_names = []

        for child_name in step_data['children']:
            if child_name.find('/') > -1:
                full_names.append(child_name)
            else:
                short_names.append(child_name)

        for child in full_names:
            child_prim = stage.GetPrimAtPath(child)
            if child_prim.IsValid():
                child_prim.SetActive(False)
        if short_names:
            for prim in stage.Traverse():
                if prim.GetName() in short_names:
                    prim.SetActive(False)



