import maya.cmds as cmds


def load_rig_model(step_data=None, project='', current_step=''):
    import library.core.config_manager as config_manager

    config_solver = config_manager.ConfigSolver(project=project)
    templates_data = config_solver.get_config('scene_template', module='builder')

    pipeline_step = current_step if current_step else step_data['step']

    render_geo = templates_data[pipeline_step].get('render_geo')

    asset_folder = step_data['published_folder']

    usd_file = step_data['files'].get('usd')
    full_path = '%s/%s' % (asset_folder, usd_file)

    render_prim = '/asset/render'

    parent_node = cmds.listRelatives(render_geo, parent=True)
    cmds.delete(render_geo)

    cmds.mayaUSDImport(file=full_path, primPath=render_prim, parent=parent_node[0])

    if cmds.objExists('rig|render'):
        cmds.rename('rig|render', 'geo')

    cmds.addAttr(render_geo, longName='asset_name', dataType='string')
    cmds.setAttr('%s.asset_name' % render_geo, step_data['code'], type='string')

    cmds.addAttr(render_geo, longName='asset_type', dataType='string')
    cmds.setAttr('%s.asset_type' % render_geo, step_data['asset_type'], type='string')

    cmds.addAttr(render_geo, longName='model_variant', dataType='string')
    cmds.setAttr('%s.model_variant' % render_geo, step_data['variant'], type='string')

    cmds.addAttr(render_geo, longName='model_version', dataType='string')
    cmds.setAttr('%s.model_version' % render_geo, step_data['version_number'], type='string')

    all_meshes = cmds.ls(type='mesh')
    print(all_meshes)
    cmds.sets(all_meshes, e=True, fe='Rig_Geo')
