from pprint import pprint
import maya.cmds as cmds

from pxr import Usd, UsdGeom

import mayaUsd


hidden_prims = {'PostAnim': ['LightRig'],
                'Layout': ['Others', 'Camera']}
def hide_prims_deferred(shape_node, hide_prims):
    print(shape_node, cmds.objExists(shape_node))
    print(hide_prims)
    filepath = cmds.getAttr('%s.filePath' % shape_node)

    stage = Usd.Stage.Open(filepath)
    to_hide = []
    for prim in stage.Traverse():
        prim_name = prim.GetName()
        if prim_name in hide_prims:
            to_hide.append(prim)

    for prim_to_hide in to_hide:
        if not prim_to_hide.IsValid():
            continue
        prim_to_hide.SetActive(False)


def create_layers(shape_node):
    full_node = cmds.ls(shape_node, l=True)[0]
    cmds.select(cl=True)
    try:
        cmds.select('%s,/World/Characters' % full_node, add=True)
    except:
        pass

    try:
        cmds.select('%s,/World/Props' % full_node, add=True)
    except:
        pass
    try:
        cmds.select('%s,/World/SetProps' % full_node, add=True)
    except:
        pass

    character_layer = cmds.createDisplayLayer(n='Ghost_caches')
    cmds.setAttr('%s.displayType' % character_layer, 2)

    try:
        cmds.select('%s,/World/Sets' % full_node, add=True)
    except:
        pass

    set_layer = cmds.createDisplayLayer(n='Usd_set')
    cmds.setAttr('%s.displayType' % set_layer, 2)


def import_shot(step_data=None, project='', current_step=''):
    print('import shot')
    pprint(step_data)
    shot_name = step_data['code']
    source_step = step_data['step']

    hide_prims = hidden_prims.get(source_step, [])

    shape_node = cmds.createNode('mayaUsdProxyShape', name='%s_USDShape' % shot_name)
    parent_node = cmds.listRelatives(shape_node, p=True)
    cmds.rename(parent_node, '%s_USD' %shot_name)
    bits = shot_name.split('_')

    season_name = bits[0]
    episode_name = '_'.join(bits[0:2])
    sequence_name = '_'.join(bits[0:3])

    shot_usd_path = 'V:/%s/publish/usd/shots/%s/%s/%s/%s/shot_assembly.usda' % (project,
                                                                                season_name,
                                                                                episode_name,
                                                                                sequence_name,
                                                                                shot_name
                                                                                )
    print(shot_usd_path)
    print('expression', '%s.time = frame' % shape_node)
    cmds.expression(o=shape_node, s='%s.time = frame;' % shape_node)
    cmds.setAttr('%s.filePath' % shape_node, shot_usd_path, type='string')

    cmds.evalDeferred("import actions.maya.lighting.import_shot as import_shot;import_shot.hide_prims_deferred('%s', %s)" % (shape_node, hide_prims))
    cmds.evalDeferred("import actions.maya.lighting.import_shot as import_shot;import_shot.create_layers('%s')" % shape_node)

