import os
import shutil
import importlib

from pxr import Usd, Sdf
import usd.old.usd_asset_layers as usd_asset_layers
import usd.lib.reparent_prim as reparent_prim

importlib.reload(reparent_prim)
importlib.reload(usd_asset_layers)

copy_files = {'ArnoldVolume': 'arnold:filename'}


def export_fx(geo_path,
              asset_name,
              output_path,
              variant,
              version,
              project,
              animated,
              hide_geometry,
              start_frame,
              end_frame
              ):
    import maya.cmds as cmds
    cmds.select(geo_path, r=True)

    if animated:
        options = {'exportUVs': '1',
                   'exportSkels': 'none',
                   'exportSkin': 'none',
                   'exportBlendShapes': '0',
                   'exportDisplayColor': '0',
                   'exportColorSets': '1',
                   'exportComponentTags': '1',
                   'defaultMeshScheme': 'catmullClark',
                   'animation': '1',
                   'eulerFilter': '0',
                   'staticSingleSample': '0',
                   'startTime': start_frame,
                   'endTime': end_frame,
                   'frameStride': '1',
                   'frameSample': '0.0',
                   'defaultUSDFormat': 'usda',
                   'parentScope': '',
                   'shadingMode': 'useRegistry',
                   'convertMaterialsTo': '[]',
                   'exportRelativeTextures': 'automatic',
                   'exportInstances': '1',
                   'exportVisibility': '1',
                   'mergeTransformAndShape': '1',
                   'stripNamespaces': '1',
                   'worldspace': '0'}
        #options = ';exportUVs=1;exportSkels=none;exportSkin=none;exportBlendShapes=0;exportDisplayColor=0;;exportColorSets=1;exportComponentTags=1;defaultMeshScheme=catmullClark;animation=0;eulerFilter=0;staticSingleSample=0;startTime=1;endTime=1;frameStride=1;frameSample=0.0;defaultUSDFormat=usda;parentScope=;shadingMode=useRegistry;convertMaterialsTo=[];exportRelativeTextures=automatic;exportInstances=1;exportVisibility=1;mergeTransformAndShape=1;stripNamespaces=1;worldspace=0'

        options_str = ';'
        for key, value in options.items():
            options_str += '%s=%s;' % (key, str(value))
        print(options_str)
        cmds.file(output_path, options=options_str, typ='USD Export', es=True, pr=True)
    else:
        cmds.arnoldExportAss(f=output_path, mask=24, asciiAss=True, fullpath=True, s=True)

    print('adding file to asset usd')
    stage = Usd.Stage.Open(output_path)

    fx_prim = stage.GetPrimAtPath('/asset/fx')
    if fx_prim.IsValid():
        fx_prim.SetTypeName("Scope")
        fx_purpose = fx_prim.GetAttribute('purpose')
        fx_purpose.Set('render')

    if hide_geometry:
        render_prim = stage.OverridePrim('/asset/render')

        render_prim.SetActive(False)

    default_prim = stage.GetDefaultPrim()

    default_prim_path = default_prim.GetPath()
    stage_layer = stage.GetRootLayer()

    reparent_prim.reparent_prim(stage_layer, '/mtl', '%s/mtl' % str(default_prim_path))
    base_path = os.path.dirname(output_path)
    publish_root_path = os.path.dirname(base_path)

    for prim in stage.Traverse():
        prim_type_name = prim.GetTypeName()
        if prim_type_name not in copy_files:
            continue
        prim_name = prim.GetName()
        path_attribute = prim.GetAttribute(copy_files[prim_type_name])

        old_path = path_attribute.Get().path
        basename = os.path.basename(old_path)
        print('old_path', old_path)
        cache_path = '%s/%s/%s' % (publish_root_path, prim_name, basename)
        print('new_path', cache_path)
        cache_folder = os.path.dirname(cache_path)
        if not os.path.exists(cache_folder):
            os.makedirs(cache_folder)

        shutil.copy2(old_path, cache_path)
        cache_asset_path = Sdf.AssetPath(cache_path)
        path_attribute.Set(value=cache_asset_path)

    stage.GetRootLayer().Save()

    return {'usd': output_path}

